/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.reporter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.impl.reporter.Reporter;

public abstract class AbstractReporter
implements Reporter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReporter.class);
    private volatile boolean running;
    private final String name;

    public AbstractReporter(String name) {
        this.name = name;
    }

    @Override
    public final void start() {
        if (!this.running) {
            this.startReporter();
            this.running = true;
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Started %s reporter for Metrics", this.name));
            }
        }
    }

    public abstract void startReporter();

    @Override
    public final void stop() {
        if (this.running) {
            this.stopReporter();
            this.running = false;
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Stopped %s reporter for Metrics", this.name));
            }
        }
    }

    public abstract void stopReporter();
}

