/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.util;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.impl.reporter.CsvReporterImpl;
import org.wso2.carbon.metrics.impl.util.ReporterBuildException;
import org.wso2.carbon.metrics.impl.util.ReporterBuilder;
import org.wso2.carbon.metrics.impl.util.ReporterDisabledException;

public class CsvReporterBuilder
implements ReporterBuilder<CsvReporterImpl> {
    private static final Logger logger = LoggerFactory.getLogger(CsvReporterBuilder.class);
    private static final String CSV_REPORTING_ENABLED = "Reporting.CSV.Enabled";
    private static final String CSV_REPORTING_LOCATION = "Reporting.CSV.Location";
    private static final String CSV_REPORTING_POLLING_PERIOD = "Reporting.CSV.PollingPeriod";
    private boolean enabled;
    private long csvReporterPollingPeriod = 60L;
    private File location;

    @Override
    public ReporterBuilder<CsvReporterImpl> configure(MetricsConfiguration configuration) {
        block3: {
            this.enabled = Boolean.parseBoolean(configuration.getProperty(CSV_REPORTING_ENABLED, String.valueOf(this.enabled)));
            String pollingPeriod = configuration.getProperty(CSV_REPORTING_POLLING_PERIOD, String.valueOf(this.csvReporterPollingPeriod));
            try {
                this.csvReporterPollingPeriod = Long.parseLong(pollingPeriod);
            }
            catch (NumberFormatException e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn(String.format("Error parsing the polling period for CSV Reporting. Using %d seconds", this.csvReporterPollingPeriod));
            }
        }
        String location = configuration.getProperty(CSV_REPORTING_LOCATION);
        if (location != null && !location.trim().isEmpty()) {
            this.location = new File(location);
        }
        return this;
    }

    public ReporterBuilder<CsvReporterImpl> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ReporterBuilder<CsvReporterImpl> setCsvReporterPollingPeriod(long csvReporterPollingPeriod) {
        this.csvReporterPollingPeriod = csvReporterPollingPeriod;
        return this;
    }

    public ReporterBuilder<CsvReporterImpl> setLocation(File location) {
        this.location = location;
        return this;
    }

    @Override
    public CsvReporterImpl build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterDisabledException, ReporterBuildException {
        if (!this.enabled) {
            throw new ReporterDisabledException("CSV Reporting for Metrics is not enabled");
        }
        if (this.location == null) {
            throw new ReporterBuildException("CSV Reporting location is not specified");
        }
        if (!this.location.exists() && !this.location.mkdir()) {
            throw new ReporterBuildException("CSV Reporting location was not created!. Location: " + this.location);
        }
        if (!this.location.isDirectory()) {
            throw new ReporterBuildException("CSV Reporting location is not a directory");
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating CSV reporter for Metrics with location '%s' and %d seconds polling period", this.location, this.csvReporterPollingPeriod));
        }
        return new CsvReporterImpl(metricRegistry, metricFilter, this.location, this.csvReporterPollingPeriod);
    }
}

