/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.util;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.common.DefaultSourceValueProvider;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.impl.reporter.DASReporterImpl;
import org.wso2.carbon.metrics.impl.util.ReporterBuildException;
import org.wso2.carbon.metrics.impl.util.ReporterBuilder;
import org.wso2.carbon.metrics.impl.util.ReporterDisabledException;

public class DASReporterBuilder
implements ReporterBuilder<DASReporterImpl> {
    private static final Logger logger = LoggerFactory.getLogger(DASReporterBuilder.class);
    private static final String DAS_REPORTING_ENABLED = "Reporting.DAS.Enabled";
    private static final String DAS_REPORTING_SOURCE = "Reporting.DAS.Source";
    private static final String DAS_REPORTING_TYPE = "Reporting.DAS.Type";
    private static final String DAS_REPORTING_RECEIVER_URL = "Reporting.DAS.ReceiverURL";
    private static final String DAS_REPORTING_AUTH_URL = "Reporting.DAS.AuthURL";
    private static final String DAS_REPORTING_USERNAME = "Reporting.DAS.Username";
    private static final String DAS_REPORTING_PASSWORD = "Reporting.DAS.Password";
    private static final String DAS_REPORTING_DATAAGENTCONFIGPATH = "Reporting.DAS.DataAgentConfigPath";
    private static final String DAS_REPORTING_POLLING_PERIOD = "Reporting.DAS.PollingPeriod";
    private boolean enabled;
    private long dasReporterPollingPeriod = 60L;
    private String source;
    private String type = "thrift";
    private String receiverURL = "tcp://localhost:7611";
    private String authURL;
    private String username = "admin";
    private String password = "admin";
    private String dataAgentConfigPath;

    @Override
    public ReporterBuilder<DASReporterImpl> configure(MetricsConfiguration configuration) {
        block3: {
            this.enabled = Boolean.parseBoolean(configuration.getProperty(DAS_REPORTING_ENABLED, String.valueOf(this.enabled)));
            String pollingPeriod = configuration.getProperty(DAS_REPORTING_POLLING_PERIOD, String.valueOf(this.dasReporterPollingPeriod));
            try {
                this.dasReporterPollingPeriod = Long.parseLong(pollingPeriod);
            }
            catch (NumberFormatException e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn(String.format("Error parsing the polling period for DAS Reporting. Using %d seconds", this.dasReporterPollingPeriod));
            }
        }
        this.source = configuration.getProperty(DAS_REPORTING_SOURCE, this.source);
        if (this.source == null) {
            this.source = DefaultSourceValueProvider.getValue();
        }
        this.type = configuration.getProperty(DAS_REPORTING_TYPE, this.type);
        this.receiverURL = configuration.getProperty(DAS_REPORTING_RECEIVER_URL, this.receiverURL);
        this.authURL = configuration.getProperty(DAS_REPORTING_AUTH_URL, this.authURL);
        this.username = configuration.getProperty(DAS_REPORTING_USERNAME, this.username);
        this.password = configuration.getProperty(DAS_REPORTING_PASSWORD, this.password);
        this.dataAgentConfigPath = configuration.getProperty(DAS_REPORTING_DATAAGENTCONFIGPATH, this.dataAgentConfigPath);
        return this;
    }

    public ReporterBuilder<DASReporterImpl> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ReporterBuilder<DASReporterImpl> setSource(String source) {
        this.source = source;
        return this;
    }

    public ReporterBuilder<DASReporterImpl> setDasReporterPollingPeriod(long dasReporterPollingPeriod) {
        this.dasReporterPollingPeriod = dasReporterPollingPeriod;
        return this;
    }

    public ReporterBuilder<DASReporterImpl> setType(String type) {
        this.type = type;
        return this;
    }

    public ReporterBuilder<DASReporterImpl> setReceiverURL(String receiverURL) {
        this.receiverURL = receiverURL;
        return this;
    }

    public ReporterBuilder<DASReporterImpl> setAuthURL(String authURL) {
        this.authURL = authURL;
        return this;
    }

    public ReporterBuilder<DASReporterImpl> setUsername(String username) {
        this.username = username;
        return this;
    }

    public ReporterBuilder<DASReporterImpl> setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public DASReporterImpl build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterDisabledException, ReporterBuildException {
        if (!this.enabled) {
            throw new ReporterDisabledException("DAS Reporting for Metrics is not enabled");
        }
        if (this.type == null || this.type.trim().length() == 0) {
            throw new ReporterBuildException("Type is not specified for DAS Reporting.");
        }
        if (this.receiverURL == null || this.receiverURL.trim().length() == 0) {
            throw new ReporterBuildException("Receiver URL is not specified for DAS Reporting.");
        }
        if (this.username == null || this.username.trim().length() == 0) {
            throw new ReporterBuildException("Username is not specified for DAS Reporting.");
        }
        if (this.password == null || this.password.trim().length() == 0) {
            throw new ReporterBuildException("Password is not specified for DAS Reporting.");
        }
        if (this.dataAgentConfigPath == null || this.dataAgentConfigPath.trim().length() == 0) {
            throw new ReporterBuildException("Data Agent config path is not specified for DAS Reporting.");
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating DAS reporter for Metrics with source '%s', protocol '%s' and %d seconds polling period", this.source, this.type, this.dasReporterPollingPeriod));
        }
        return new DASReporterImpl(metricRegistry, metricFilter, this.source, this.type, this.receiverURL, this.authURL, this.username, this.password, this.dataAgentConfigPath, this.dasReporterPollingPeriod);
    }
}

