/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.util;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.impl.reporter.JmxReporterImpl;
import org.wso2.carbon.metrics.impl.util.ReporterBuildException;
import org.wso2.carbon.metrics.impl.util.ReporterBuilder;
import org.wso2.carbon.metrics.impl.util.ReporterDisabledException;

public class JmxReporterBuilder
implements ReporterBuilder<JmxReporterImpl> {
    private static final Logger logger = LoggerFactory.getLogger(JmxReporterBuilder.class);
    private static final String JMX_REPORTING_DOMAIN = "org.wso2.carbon.metrics";
    private static final String JMX_REPORTING_ENABLED = "Reporting.JMX.Enabled";
    private boolean enabled;

    @Override
    public ReporterBuilder<JmxReporterImpl> configure(MetricsConfiguration configuration) {
        this.enabled = Boolean.parseBoolean(configuration.getProperty(JMX_REPORTING_ENABLED, String.valueOf(this.enabled)));
        return this;
    }

    public ReporterBuilder<JmxReporterImpl> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public JmxReporterImpl build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterDisabledException, ReporterBuildException {
        if (!this.enabled) {
            throw new ReporterDisabledException("JMX Reporting for Metrics is not enabled");
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating JMX reporter for Metrics with domain '%s'", JMX_REPORTING_DOMAIN));
        }
        return new JmxReporterImpl(metricRegistry, metricFilter, JMX_REPORTING_DOMAIN);
    }
}

