/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.manager;

import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Gauge;
import org.wso2.carbon.metrics.manager.Histogram;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.ServiceReferenceHolder;
import org.wso2.carbon.metrics.manager.Timer;
import org.wso2.carbon.metrics.manager.exception.MetricNotFoundException;
import org.wso2.carbon.metrics.manager.jmx.MetricManagerMXBeanImpl;

public final class MetricManager {
    private static final Logger logger = LoggerFactory.getLogger(MetricManager.class);
    private static final String MBEAN_NAME = "org.wso2.carbon:type=MetricManager";

    private MetricManager() {
    }

    public static String name(String name, String ... names) {
        StringBuilder builder = new StringBuilder();
        MetricManager.append(builder, name);
        if (names != null) {
            for (String s : names) {
                MetricManager.append(builder, s);
            }
        }
        return builder.toString();
    }

    public static String name(Class<?> klass, String ... names) {
        return MetricManager.name(klass.getName(), names);
    }

    private static void append(StringBuilder builder, String part) {
        if (part != null && !part.isEmpty()) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
    }

    public static Meter getMeter(String name) throws MetricNotFoundException {
        return ServiceReferenceHolder.getInstance().getMetricService().getMeter(name);
    }

    public static Meter meter(String name, Level ... levels) {
        return ServiceReferenceHolder.getInstance().getMetricService().meter(name, levels);
    }

    @Deprecated
    public static Meter meter(Level level, String name) {
        return ServiceReferenceHolder.getInstance().getMetricService().meter(name, level);
    }

    public static Counter getCounter(String name) throws MetricNotFoundException {
        return ServiceReferenceHolder.getInstance().getMetricService().getCounter(name);
    }

    public static Counter counter(String name, Level ... levels) {
        return ServiceReferenceHolder.getInstance().getMetricService().counter(name, levels);
    }

    @Deprecated
    public static Counter counter(Level level, String name) {
        return ServiceReferenceHolder.getInstance().getMetricService().counter(name, level);
    }

    public static Timer getTimer(String name) throws MetricNotFoundException {
        return ServiceReferenceHolder.getInstance().getMetricService().timer(name);
    }

    public static Timer timer(String name, Level level) {
        return ServiceReferenceHolder.getInstance().getMetricService().timer(name, level);
    }

    @Deprecated
    public static Timer timer(Level level, String name) {
        return ServiceReferenceHolder.getInstance().getMetricService().timer(name, level);
    }

    public static Histogram getHistogram(String name) throws MetricNotFoundException {
        return ServiceReferenceHolder.getInstance().getMetricService().getHistogram(name);
    }

    public static Histogram histogram(String name, Level ... levels) {
        return ServiceReferenceHolder.getInstance().getMetricService().histogram(name, levels);
    }

    @Deprecated
    public static Histogram histogram(Level level, String name) {
        return ServiceReferenceHolder.getInstance().getMetricService().histogram(name, level);
    }

    public static <T> void gauge(String name, Level level, Gauge<T> gauge) {
        ServiceReferenceHolder.getInstance().getMetricService().gauge(name, level, gauge);
    }

    @Deprecated
    public static <T> void gauge(Level level, String name, Gauge<T> gauge) {
        ServiceReferenceHolder.getInstance().getMetricService().gauge(name, level, gauge);
    }

    public static <T> void cachedGauge(String name, Level level, long timeout, TimeUnit timeoutUnit, Gauge<T> gauge) {
        ServiceReferenceHolder.getInstance().getMetricService().cachedGauge(name, level, timeout, timeoutUnit, gauge);
    }

    @Deprecated
    public static <T> void cachedGauge(Level level, String name, long timeout, TimeUnit timeoutUnit, Gauge<T> gauge) {
        ServiceReferenceHolder.getInstance().getMetricService().cachedGauge(name, level, timeout, timeoutUnit, gauge);
    }

    public static <T> void cachedGauge(String name, Level level, long timeout, Gauge<T> gauge) {
        ServiceReferenceHolder.getInstance().getMetricService().cachedGauge(name, level, timeout, TimeUnit.SECONDS, gauge);
    }

    @Deprecated
    public static <T> void cachedGauge(Level level, String name, long timeout, Gauge<T> gauge) {
        ServiceReferenceHolder.getInstance().getMetricService().cachedGauge(name, level, timeout, TimeUnit.SECONDS, gauge);
    }

    public static void registerMXBean() {
        block4: {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName name = new ObjectName(MBEAN_NAME);
                if (mBeanServer.isRegistered(name)) {
                    mBeanServer.unregisterMBean(name);
                }
                MetricManagerMXBeanImpl mxBean = new MetricManagerMXBeanImpl(ServiceReferenceHolder.getInstance().getMetricService());
                mBeanServer.registerMBean(mxBean, name);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("MetricManagerMXBean registered under name: %s", name));
                }
            }
            catch (JMException e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error(String.format("MetricManagerMXBean registration failed. Name: %s", MBEAN_NAME), e);
            }
        }
    }

    public static void unregisterMXBean() {
        block4: {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName name = new ObjectName(MBEAN_NAME);
                if (mBeanServer.isRegistered(name)) {
                    mBeanServer.unregisterMBean(name);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("MetricManagerMXBean with name '%s' was unregistered.", name));
                }
            }
            catch (JMException e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error(String.format("MetricManagerMXBean with name '%s' was failed to unregister", MBEAN_NAME), e);
            }
        }
    }
}

