/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.manager.internal;

import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.MetricService;
import org.wso2.carbon.metrics.manager.ServiceReferenceHolder;

public class MetricManagerComponent {
    private static final Logger log = LoggerFactory.getLogger(MetricManagerComponent.class);
    private ServiceReferenceHolder serviceReferenceHolder = ServiceReferenceHolder.getInstance();

    protected void activate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug("Metrics manager component activated");
        }
        MetricManager.registerMXBean();
    }

    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug("Deactivating Metrics manager component");
        }
        MetricManager.unregisterMXBean();
    }

    protected void setMetricService(MetricService metricService) {
        this.serviceReferenceHolder.setMetricService(metricService);
    }

    protected void unsetMetricService(MetricService metricService) {
        this.serviceReferenceHolder.setMetricService(null);
    }
}

