/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.pet;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.annotation.Timed;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;
import org.wso2.msf4j.examples.petstore.util.JedisUtil;
import org.wso2.msf4j.examples.petstore.util.model.Category;

@HTTPMonitored
@Path(value="/category")
public class PetCategoryService {
    private static final Logger log = LoggerFactory.getLogger(PetCategoryService.class);

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response addCategory(Category category) {
        String name = category.getName();
        JedisUtil.sadd("petstore:pet:categories", name);
        log.info("Added category");
        return Response.status(Response.Status.OK).entity("Category with name " + name + " successfully added").build();
    }

    @DELETE
    @Path(value="/{name}")
    @Timed
    public Response deleteCategory(@PathParam(value="name") String name) {
        if (!JedisUtil.smembers("petstore:pet:categories").contains(name)) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        String categoryKey = "petstore:pet:category." + name;
        JedisUtil.srem("petstore:pet:categories", name);
        JedisUtil.del(categoryKey);
        log.info("Deleted category: " + name);
        return Response.status(Response.Status.OK).entity("OK").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{name}")
    @Timed
    public Response getCategory(@PathParam(value="name") String name) {
        if (!JedisUtil.smembers("petstore:pet:categories").contains(name)) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        log.info("Got category");
        return Response.status(Response.Status.OK).entity(new Category(name)).build();
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @Timed
    public Set<Category> getAllCategories() {
        Set<String> smembers = JedisUtil.smembers("petstore:pet:categories");
        HashSet<Category> categories = new HashSet<Category>(smembers.size());
        for (String smember : smembers) {
            categories.add(new Category(smember));
        }
        return categories;
    }
}

