/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.pet;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.annotation.Timed;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;
import org.wso2.msf4j.examples.petstore.util.JedisUtil;
import org.wso2.msf4j.examples.petstore.util.model.Pet;

@HTTPMonitored
@Path(value="/pet")
public class PetService {
    private static final Logger log = LoggerFactory.getLogger(PetService.class);

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response addPet(Pet pet) {
        String categoryName = pet.getCategory().getName();
        if (!JedisUtil.smembers("petstore:pet:categories").contains(categoryName)) {
            JedisUtil.sadd("petstore:pet:categories", categoryName);
        }
        String categoryKey = "petstore:pet:category." + categoryName;
        JedisUtil.sadd(categoryKey, pet.getId());
        String id = pet.getId();
        String petKey = "petstore:pet:id." + id;
        if (JedisUtil.get(petKey) != null) {
            return Response.status(Response.Status.CONFLICT).entity("Pet with ID " + id + " already exists").build();
        }
        JedisUtil.set(petKey, new Gson().toJson(pet));
        log.info("Added pet");
        return Response.status(Response.Status.OK).entity("Pet with ID " + id + " successfully added").build();
    }

    @DELETE
    @Path(value="/{id}")
    @Timed
    public Response deletePet(@PathParam(value="id") String id) {
        String petKey = "petstore:pet:id." + id;
        String petValue = JedisUtil.get(petKey);
        if (petValue == null || petValue.isEmpty()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        Pet pet = new Gson().fromJson(petValue, Pet.class);
        String categoryKey = "petstore:pet:category." + pet.getCategory().getName();
        JedisUtil.srem(categoryKey, pet.getId());
        JedisUtil.del(petKey);
        log.info("Deleted pet");
        return Response.status(Response.Status.OK).entity("OK").build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Timed
    public Response updatePet(Pet pet) {
        String id = pet.getId();
        String petKey = "petstore:pet:id." + id;
        String json = JedisUtil.get(petKey);
        if (json == null || json.isEmpty()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        JedisUtil.set(petKey, new Gson().toJson(pet));
        log.info("Updated pet");
        return Response.status(Response.Status.OK).entity("Pet with ID " + id + " successfully updated").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Timed
    public Response getPet(@PathParam(value="id") String id) {
        String json = JedisUtil.get("petstore:pet:id." + id);
        if (json == null || json.isEmpty()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        log.info("Got pet");
        return Response.status(Response.Status.OK).entity(new Gson().fromJson(json, Pet.class)).build();
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @Timed
    public List<Pet> getAllPets() {
        ArrayList<Pet> result = new ArrayList<Pet>();
        Set<String> categories = JedisUtil.smembers("petstore:pet:categories");
        for (String category : categories) {
            Set<String> pets = JedisUtil.smembers("petstore:pet:category." + category);
            for (String petID : pets) {
                String petValue = JedisUtil.get("petstore:pet:id." + petID);
                result.add(new Gson().fromJson(petValue, Pet.class));
            }
        }
        return result;
    }

    static {
        log.info("SENTINEL_HOST: {}", (Object)JedisUtil.getSentinelHost());
        log.info("SENTINEL1_PORT: {}", (Object)JedisUtil.getSentinelPort());
    }
}

