/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.ChunkResponder;
import org.wso2.msf4j.HttpResponder;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.ServiceMethodInfo;

final class WrappedHttpResponder
implements HttpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(WrappedHttpResponder.class);
    private final HttpResponder delegate;
    private final Iterable<? extends Interceptor> interceptors;
    private final HttpRequest httpRequest;
    private final ServiceMethodInfo serviceMethodInfo;

    public WrappedHttpResponder(HttpResponder delegate, Iterable<? extends Interceptor> interceptors, HttpRequest httpRequest, ServiceMethodInfo serviceMethodInfo) {
        this.delegate = delegate;
        this.interceptors = interceptors;
        this.httpRequest = httpRequest;
        this.serviceMethodInfo = serviceMethodInfo;
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object) {
        this.delegate.sendJson(status, object);
        this.runInterceptor(status);
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object, Type type) {
        this.delegate.sendJson(status, object, type);
        this.runInterceptor(status);
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object, Type type, Gson gson) {
        this.delegate.sendJson(status, object, type, gson);
        this.runInterceptor(status);
    }

    @Override
    public void sendString(HttpResponseStatus status, String data) {
        this.delegate.sendString(status, data);
        this.runInterceptor(status);
    }

    @Override
    public void sendString(HttpResponseStatus status, String data, @Nullable Multimap<String, String> headers) {
        this.delegate.sendString(status, data, headers);
        this.runInterceptor(status);
    }

    @Override
    public void sendStatus(HttpResponseStatus status) {
        this.delegate.sendStatus(status);
        this.runInterceptor(status);
    }

    @Override
    public void sendStatus(HttpResponseStatus status, Multimap<String, String> headers) {
        this.delegate.sendStatus(status, headers);
        this.runInterceptor(status);
    }

    @Override
    public void sendByteArray(HttpResponseStatus status, byte[] bytes, Multimap<String, String> headers) {
        this.delegate.sendByteArray(status, bytes, headers);
        this.runInterceptor(status);
    }

    @Override
    public void sendBytes(HttpResponseStatus status, ByteBuffer buffer, Multimap<String, String> headers) {
        this.delegate.sendBytes(status, buffer, headers);
        this.runInterceptor(status);
    }

    @Override
    public ChunkResponder sendChunkStart(final HttpResponseStatus status, Multimap<String, String> headers) {
        final ChunkResponder chunkResponder = this.delegate.sendChunkStart(status, headers);
        return new ChunkResponder(){

            @Override
            public void sendChunk(ByteBuffer chunk) throws IOException {
                chunkResponder.sendChunk(chunk);
            }

            @Override
            public void sendChunk(ByteBuf chunk) throws IOException {
                chunkResponder.sendChunk(chunk);
            }

            @Override
            public void close() throws IOException {
                chunkResponder.close();
                WrappedHttpResponder.this.runInterceptor(status);
            }
        };
    }

    @Override
    public void sendContent(HttpResponseStatus status, ByteBuf content, String contentType, Multimap<String, String> headers) {
        this.delegate.sendContent(status, content, contentType, headers);
        this.runInterceptor(status);
    }

    @Override
    public void sendFile(File file, String contentType, Multimap<String, String> headers) throws IOException {
        this.delegate.sendFile(file, contentType, headers);
        this.runInterceptor(HttpResponseStatus.OK);
    }

    private void runInterceptor(HttpResponseStatus status) {
        for (Interceptor interceptor : this.interceptors) {
            try {
                interceptor.postCall(this.httpRequest, status, this.serviceMethodInfo);
            }
            catch (Throwable t) {
                LOG.error("Post handler hook threw exception: ", t);
            }
        }
    }
}

