/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.security.oauth2;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.msf4j.HttpResponder;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.security.MSF4JSecurityException;
import org.wso2.msf4j.security.SecurityErrorCode;
import org.wso2.msf4j.util.SystemVariableUtil;

public class OAuth2SecurityInterceptor
implements Interceptor {
    private final Log log = LogFactory.getLog(OAuth2SecurityInterceptor.class);
    private static final String AUTHORIZATION_HTTP_HEADER = "Authorization";
    private static final String AUTH_TYPE_OAUTH2 = "OAuth2";
    private static final String BEARER_PREFIX = "bearer";
    private static final String AUTH_SERVER_URL_KEY = "AUTH_SERVER_URL";
    private static final String AUTH_SERVER_URL = SystemVariableUtil.getValue("AUTH_SERVER_URL", null);
    private static final String TRUST_STORE = "TRUST_STORE";
    private static final String TRUST_STORE_PASSWORD = "TRUST_STORE_PASSWORD";

    @Override
    public boolean preCall(HttpRequest request, HttpResponder responder, ServiceMethodInfo serviceMethodInfo) {
        try {
            HttpHeaders headers = request.headers();
            if (headers != null && headers.contains(AUTHORIZATION_HTTP_HEADER)) {
                String authHeader = headers.get(AUTHORIZATION_HTTP_HEADER);
                return this.validateToken(authHeader);
            }
            throw new MSF4JSecurityException(SecurityErrorCode.AUTHENTICATION_FAILURE, "Missing Authorization header is the request.`");
        }
        catch (MSF4JSecurityException e) {
            SecurityErrorCode errorCode = e.getErrorCode();
            this.log.error(e.getMessage() + " Requested Path: " + request.getUri());
            this.handleSecurityError(errorCode, responder);
            return false;
        }
    }

    @Override
    public void postCall(HttpRequest request, HttpResponseStatus status, ServiceMethodInfo serviceMethodInfo) {
    }

    private boolean validateToken(String authHeader) throws MSF4JSecurityException {
        String accessToken = this.extractAccessToken(authHeader);
        String responseStr = this.getValidatedTokenResponse(accessToken);
        Map<String, String> responseData = this.getResponseDataMap(responseStr);
        if (!Boolean.parseBoolean(responseData.get("active"))) {
            throw new MSF4JSecurityException(SecurityErrorCode.AUTHENTICATION_FAILURE, "Invalid Access token.");
        }
        return true;
    }

    private String extractAccessToken(String authHeader) throws MSF4JSecurityException {
        String[] authHeaderParts;
        if ((authHeader = authHeader.trim()).toLowerCase().startsWith(BEARER_PREFIX) && (authHeaderParts = authHeader.split(" ")).length == 2) {
            return authHeaderParts[1];
        }
        throw new MSF4JSecurityException(SecurityErrorCode.INVALID_AUTHORIZATION_HEADER, "Invalid Authorization header: " + authHeader);
    }

    private String getValidatedTokenResponse(String accessToken) throws MSF4JSecurityException {
        try {
            URL url = new URL(AUTH_SERVER_URL);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setDoOutput(true);
            urlConn.setRequestMethod(HttpMethod.POST.name());
            urlConn.getOutputStream().write(("token=" + accessToken).getBytes(Charsets.UTF_8));
            return new String(ByteStreams.toByteArray(urlConn.getInputStream()), Charsets.UTF_8);
        }
        catch (IOException e) {
            this.log.error("Error invoking Authorization Server", e);
            throw new MSF4JSecurityException(SecurityErrorCode.GENERIC_ERROR, "Error invoking Authorization Server", e);
        }
    }

    private Map<String, String> getResponseDataMap(String responseStr) {
        Gson gson = new Gson();
        Type typeOfMapOfStrings = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)gson.fromJson(responseStr, typeOfMapOfStrings);
    }

    private void handleSecurityError(SecurityErrorCode errorCode, HttpResponder responder) {
        if (errorCode == SecurityErrorCode.AUTHENTICATION_FAILURE || errorCode == SecurityErrorCode.INVALID_AUTHORIZATION_HEADER) {
            ArrayListMultimap<String, String> map = ArrayListMultimap.create();
            map.put("WWW-Authenticate", AUTH_TYPE_OAUTH2);
            responder.sendStatus(HttpResponseStatus.UNAUTHORIZED, map);
        } else if (errorCode == SecurityErrorCode.AUTHORIZATION_FAILURE) {
            responder.sendStatus(HttpResponseStatus.FORBIDDEN);
        } else {
            responder.sendStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    static {
        if (AUTH_SERVER_URL == null) {
            throw new RuntimeException("AUTH_SERVER_URL is not specified.");
        }
        String trustStore = SystemVariableUtil.getValue(TRUST_STORE, null);
        String trustStorePassword = SystemVariableUtil.getValue(TRUST_STORE_PASSWORD, null);
        if (trustStore != null && !trustStore.isEmpty() && trustStorePassword != null && !trustStorePassword.isEmpty()) {
            System.setProperty("javax.net.ssl.trustStore", trustStore);
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
    }
}

