/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.ReadOnlyCommonSEHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CommonSEHeader
extends Header
implements ReadOnlyCommonSEHeader {
    private URL jku;
    private JWK jwk;
    private URL x5u;
    private Base64URL x5t;
    private List<Base64> x5c;
    private String kid;

    protected CommonSEHeader(Algorithm alg) {
        super(alg);
    }

    @Override
    public URL getJWKURL() {
        return this.jku;
    }

    public void setJWKURL(URL jku) {
        this.jku = jku;
    }

    @Override
    public JWK getJWK() {
        return this.jwk;
    }

    public void setJWK(JWK jwk) {
        this.jwk = jwk;
    }

    @Override
    public URL getX509CertURL() {
        return this.x5u;
    }

    public void setX509CertURL(URL x5u) {
        this.x5u = x5u;
    }

    @Override
    public Base64URL getX509CertThumbprint() {
        return this.x5t;
    }

    public void setX509CertThumbprint(Base64URL x5t) {
        this.x5t = x5t;
    }

    @Override
    public List<Base64> getX509CertChain() {
        return this.x5c;
    }

    public void setX509CertChain(List<Base64> x5c) {
        if (x5c == null) {
            return;
        }
        this.x5c = Collections.unmodifiableList(x5c);
    }

    @Override
    public String getKeyID() {
        return this.kid;
    }

    public void setKeyID(String kid) {
        this.kid = kid;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        if (this.jku != null) {
            o.put("jku", this.jku.toString());
        }
        if (this.jwk != null) {
            o.put("jwk", this.jwk.toJSONObject());
        }
        if (this.x5u != null) {
            o.put("x5u", this.x5u.toString());
        }
        if (this.x5t != null) {
            o.put("x5t", this.x5t.toString());
        }
        if (this.x5c != null) {
            o.put("x5c", this.x5c);
        }
        if (this.kid != null) {
            o.put("kid", this.kid);
        }
        return o;
    }
}

