/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.BufferFactory;
import org.wso2.carbon.messaging.CarbonTransportInitializer;
import org.wso2.carbon.transport.http.netty.common.Constants;
import org.wso2.carbon.transport.http.netty.common.disruptor.config.DisruptorConfig;
import org.wso2.carbon.transport.http.netty.common.disruptor.config.DisruptorFactory;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLHandlerFactory;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.listener.CustomHttpObjectAggregator;
import org.wso2.carbon.transport.http.netty.listener.CustomHttpRequestDecoder;
import org.wso2.carbon.transport.http.netty.listener.RequestSizeValidationConfiguration;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.listener.WorkerPoolDispatchingSourceHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class CarbonNettyServerInitializer
extends ChannelInitializer<SocketChannel>
implements CarbonTransportInitializer {
    private static final Logger log = LoggerFactory.getLogger(CarbonNettyServerInitializer.class);
    private ConnectionManager connectionManager;
    private ListenerConfiguration listenerConfiguration;
    private SSLConfig sslConfig;
    private Map<String, SSLConfig> sslConfigMap;

    public CarbonNettyServerInitializer(ListenerConfiguration listenerConfiguration) {
        this.listenerConfiguration = listenerConfiguration;
    }

    @Override
    public void setup(Map<String, String> parameters) {
        if (parameters != null && parameters.get("output.content.buffer.size") != null) {
            BufferFactory.createInstance(Integer.parseInt(parameters.get("output.content.buffer.size")));
        }
        try {
            this.connectionManager = ConnectionManager.getInstance(parameters);
            if (this.listenerConfiguration.getEnableDisruptor().booleanValue()) {
                if (parameters != null && !parameters.isEmpty()) {
                    log.debug("Disruptor is enabled");
                    log.debug("Disruptor configuration creating");
                    DisruptorConfig disruptorConfig = new DisruptorConfig(parameters.getOrDefault("disruptor.buffer.size", "512"), parameters.getOrDefault("disruptor.count", "5"), parameters.getOrDefault("disruptor.eventhandler.count", "1"), parameters.getOrDefault("disruptor.wait.strategy", "PHASED_BACKOFF"), Boolean.parseBoolean(parameters.getOrDefault("share.disruptor.with.outbound", "false")), parameters.getOrDefault("disruptor.consumer.worker.pool.size", "0"));
                    DisruptorFactory.createDisruptors(DisruptorFactory.DisruptorType.INBOUND, disruptorConfig);
                } else {
                    log.warn("Disruptor specific parameters are not specified in configuration hence using default configs");
                    DisruptorConfig disruptorConfig = new DisruptorConfig();
                    DisruptorFactory.createDisruptors(DisruptorFactory.DisruptorType.INBOUND, disruptorConfig);
                }
            } else if (parameters != null && !parameters.isEmpty()) {
                int executorWorkerPoolSize = Integer.parseInt(parameters.getOrDefault("executor.workerpool.size", String.valueOf(Constants.DEFAULT_EXECUTOR_WORKER_POOL_SIZE)));
                log.debug("Disruptor is disabled and using executor thread pool with size of " + executorWorkerPoolSize);
                if (executorWorkerPoolSize > 0) {
                    this.listenerConfiguration.setWorkerPoolSize(executorWorkerPoolSize);
                } else {
                    log.warn("Please enable disruptor or specify executorHandlerThreadPool size greater than 0, starting with default value");
                    this.listenerConfiguration.setWorkerPoolSize(Constants.DEFAULT_EXECUTOR_WORKER_POOL_SIZE);
                }
            } else {
                log.warn("ExecutorHandlerThreadPool size is not specified using the default value");
                this.listenerConfiguration.setWorkerPoolSize(Constants.DEFAULT_EXECUTOR_WORKER_POOL_SIZE);
            }
        }
        catch (Exception e) {
            log.error("Error initializing the transport ", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        SslHandler sslHandler;
        if (log.isDebugEnabled()) {
            log.debug("Initializing source channel pipeline");
        }
        String host = ch.remoteAddress().getHostName();
        int port = ch.remoteAddress().getPort();
        String id = host + ":" + port;
        if (this.sslConfigMap.get(id) != null) {
            sslHandler = new SSLHandlerFactory(this.sslConfigMap.get(id)).create();
            ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        } else if (this.sslConfig != null) {
            sslHandler = new SSLHandlerFactory(this.sslConfig).create();
            ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        }
        ChannelPipeline p = ch.pipeline();
        p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        if (RequestSizeValidationConfiguration.getInstance().isHeaderSizeValidation()) {
            p.addLast("decoder", (ChannelHandler)new CustomHttpRequestDecoder());
        } else {
            p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        }
        if (RequestSizeValidationConfiguration.getInstance().isRequestSizeValidation()) {
            p.addLast("custom-aggregator", (ChannelHandler)new CustomHttpObjectAggregator());
        }
        p.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
        p.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        try {
            if (this.listenerConfiguration.getEnableDisruptor().booleanValue()) {
                log.debug("Selecting SourceHandler");
                p.addLast("handler", (ChannelHandler)new SourceHandler(this.connectionManager, this.listenerConfiguration));
            } else {
                log.debug("Selecting WorkerPoolDispatchingSourceHandler");
                p.addLast("handler", (ChannelHandler)new WorkerPoolDispatchingSourceHandler(this.connectionManager, this.listenerConfiguration));
            }
        }
        catch (Exception e) {
            log.error("Cannot Create SourceHandler ", e);
        }
    }

    @Override
    public boolean isServerInitializer() {
        return true;
    }

    public void setSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public void setSslConfigMap(Map<String, SSLConfig> sslConfigMap) {
        this.sslConfigMap = sslConfigMap;
    }
}

