/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.transports.CarbonTransport;
import org.wso2.msf4j.DefaultSessionManager;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.MicroservicesRegistry;
import org.wso2.msf4j.SessionManager;
import org.wso2.msf4j.SwaggerService;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.util.RuntimeAnnotations;

@Component(name="org.wso2.msf4j.internal.MicroServicesServerSC", immediate=true, property={"componentName=wso2-microservices-server"})
public class MicroservicesServerSC
implements RequiredCapabilityListener {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesServerSC.class);

    @Activate
    protected void start(BundleContext bundleContext) {
    }

    @Reference(name="microservice", service=Microservice.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeService")
    protected void addService(Microservice service, Map properties) {
        Object channelId = properties.get("CHANNEL_ID");
        Object contextPath = properties.get("contextPath");
        if (contextPath != null) {
            HashMap valuesMap = new HashMap();
            valuesMap.put("value", contextPath);
            RuntimeAnnotations.putAnnotation(service.getClass(), Path.class, valuesMap);
        }
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (channelId != null) {
            MicroservicesRegistryImpl microservicesRegistry = microservicesRegistries.get(channelId.toString());
            if (microservicesRegistry == null) {
                throw new RuntimeException("Couldn't found the registry for channel ID " + channelId);
            }
            if (contextPath == null) {
                microservicesRegistry.addService(service);
            } else {
                microservicesRegistry.addService(contextPath.toString(), (Object)service);
            }
        } else if (contextPath == null) {
            microservicesRegistries.values().forEach(registry -> registry.addService(service));
        } else {
            microservicesRegistries.values().forEach(registry -> registry.addService(contextPath.toString(), (Object)service));
        }
    }

    protected void removeService(Microservice service, Map properties) {
        MicroservicesRegistryImpl microservicesRegistry;
        Object channelId = properties.get("CHANNEL_ID");
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (channelId != null && (microservicesRegistry = microservicesRegistries.get(channelId.toString())) != null) {
            microservicesRegistry.removeService(service);
        }
    }

    @Reference(name="swaggerservice", service=SwaggerService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeSwaggerService")
    protected void addSwaggerService(SwaggerService service, Map properties) {
        Object channelId = properties.get("CHANNEL_ID");
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (channelId != null) {
            MicroservicesRegistryImpl microservicesRegistry = microservicesRegistries.get(channelId.toString());
            if (microservicesRegistry == null) {
                throw new RuntimeException("Couldn't found the registry for channel ID " + channelId);
            }
            microservicesRegistry.addService(service);
        } else {
            microservicesRegistries.values().forEach(registry -> registry.addService(service));
        }
    }

    protected void removeSwaggerService(SwaggerService service, Map properties) {
        MicroservicesRegistryImpl microservicesRegistry;
        Object channelId = properties.get("CHANNEL_ID");
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (channelId != null && (microservicesRegistry = microservicesRegistries.get(channelId.toString())) != null) {
            microservicesRegistry.removeService(service);
        }
    }

    @Reference(name="carbon-transport", service=CarbonTransport.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="removeCarbonTransport")
    protected void addCarbonTransport(CarbonTransport carbonTransport) {
        MicroservicesRegistryImpl microservicesRegistry = new MicroservicesRegistryImpl();
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("CHANNEL_ID", carbonTransport.getId());
        microservicesRegistries.put(carbonTransport.getId(), microservicesRegistry);
        DataHolder.getInstance().getBundleContext().registerService(MicroservicesRegistry.class, (Object)microservicesRegistry, properties);
    }

    protected void removeCarbonTransport(CarbonTransport carbonTransport) {
        DataHolder.getInstance().getMicroservicesRegistries().remove(carbonTransport.getId());
    }

    @Reference(name="interceptor", service=Interceptor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeInterceptor")
    protected void addInterceptor(Interceptor interceptor, Map properties) {
        Object channelId = properties.get("CHANNEL_ID");
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (channelId != null) {
            MicroservicesRegistryImpl microservicesRegistry = microservicesRegistries.get(channelId.toString());
            if (microservicesRegistry == null) {
                throw new RuntimeException("Couldn't found the registry for channel ID " + channelId);
            }
            microservicesRegistry.addInterceptor(interceptor);
        } else {
            microservicesRegistries.values().forEach(registry -> registry.addInterceptor(interceptor));
        }
    }

    protected void removeInterceptor(Interceptor interceptor, Map properties) {
        Object channelId = properties.get("CHANNEL_ID");
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (channelId != null) {
            microservicesRegistries.get(channelId.toString()).removeInterceptor(interceptor);
        }
    }

    @Reference(name="exception-mapper", service=ExceptionMapper.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeExceptionMapper")
    protected void addExceptionMapper(ExceptionMapper exceptionMapper, Map properties) {
        Object channelId = properties.get("CHANNEL_ID");
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (channelId != null) {
            MicroservicesRegistryImpl microservicesRegistry = microservicesRegistries.get(channelId.toString());
            if (microservicesRegistry == null) {
                throw new RuntimeException("Couldn't found the registry for channel ID " + channelId);
            }
            microservicesRegistry.addExceptionMapper(exceptionMapper);
        } else {
            microservicesRegistries.values().forEach(registry -> registry.addExceptionMapper(exceptionMapper));
        }
    }

    protected void removeExceptionMapper(ExceptionMapper exceptionMapper, Map properties) {
        Object channelId = properties.get("CHANNEL_ID");
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (channelId != null) {
            microservicesRegistries.get(channelId.toString()).removeExceptionMapper(exceptionMapper);
        }
    }

    @Reference(name="session-manager", service=SessionManager.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="removeSessionManager")
    protected void addSessionManager(SessionManager sessionManager, Map properties) {
        Object channelId = properties.get("CHANNEL_ID");
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        sessionManager.init();
        if (channelId != null) {
            MicroservicesRegistryImpl microservicesRegistry = microservicesRegistries.get(channelId.toString());
            if (microservicesRegistry == null) {
                throw new RuntimeException("Couldn't found the registry for channel ID " + channelId);
            }
            microservicesRegistry.setSessionManager(sessionManager);
        } else {
            microservicesRegistries.values().forEach(registry -> registry.setSessionManager(sessionManager));
        }
    }

    protected void removeSessionManager(SessionManager sessionManager, Map properties) {
        Object channelId = properties.get("CHANNEL_ID");
        Map<String, MicroservicesRegistryImpl> microservicesRegistries = DataHolder.getInstance().getMicroservicesRegistries();
        if (channelId != null) {
            sessionManager.stop();
            DefaultSessionManager defaultSessionManager = new DefaultSessionManager();
            defaultSessionManager.init();
            microservicesRegistries.get(channelId.toString()).setSessionManager(defaultSessionManager);
        }
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        DataHolder.getInstance().getBundleContext().registerService(MicroservicesServerSC.class, (Object)this, null);
        log.info("All microservices are available");
    }
}

