/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.pet;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.annotation.Timed;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;
import org.wso2.msf4j.examples.petstore.util.model.Pet;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@HTTPMonitored
@Path(value="/pet")
public class PetService {
    private static final Logger log = LoggerFactory.getLogger(PetService.class);
    private static String REDIS_MASTER_HOST = System.getenv("REDIS_MASTER_HOST");
    private static int REDIS_MASTER_PORT = Integer.parseInt(System.getenv("REDIS_MASTER_PORT"));
    private static final JedisPool pool;

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response addPet(Pet pet) {
        log.info("Adding pet");
        String categoryName = pet.getCategory().getName();
        try (Jedis jedis = pool.getResource();){
            if (!jedis.smembers("petstore:pet:categories").contains(categoryName)) {
                jedis.sadd("petstore:pet:categories", categoryName);
            }
            String categoryKey = "petstore:pet:category." + categoryName;
            jedis.sadd(categoryKey, pet.getId());
            String id = pet.getId();
            String petKey = "petstore:pet:id." + id;
            if (jedis.get(petKey) != null) {
                Response response = Response.status(Response.Status.CONFLICT).entity("Pet with ID " + id + " already exists").build();
                return response;
            }
            jedis.set(petKey, new Gson().toJson(pet));
            log.info("Added pet");
            Response response = Response.status(Response.Status.OK).entity("Pet with ID " + id + " successfully added").build();
            return response;
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Timed
    public Response deletePet(@PathParam(value="id") String id) {
        String petKey = "petstore:pet:id." + id;
        try (Jedis jedis = pool.getResource();){
            String petValue = jedis.get(petKey);
            if (petValue == null || petValue.isEmpty()) {
                Response response = Response.status(Response.Status.NOT_FOUND).build();
                return response;
            }
            Pet pet = new Gson().fromJson(petValue, Pet.class);
            String categoryKey = "petstore:pet:category." + pet.getCategory().getName();
            jedis.srem(categoryKey, pet.getId());
            jedis.del(petKey);
            log.info("Deleted pet");
            Response response = Response.status(Response.Status.OK).entity("OK").build();
            return response;
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Timed
    public Response updatePet(Pet pet) {
        String id = pet.getId();
        String petKey = "petstore:pet:id." + id;
        try (Jedis jedis = pool.getResource();){
            String json = jedis.get(petKey);
            if (json == null || json.isEmpty()) {
                Response response = Response.status(Response.Status.NOT_FOUND).build();
                return response;
            }
            jedis.set(petKey, new Gson().toJson(pet));
            log.info("Updated pet");
            Response response = Response.status(Response.Status.OK).entity("Pet with ID " + id + " successfully updated").build();
            return response;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Timed
    public Response getPet(@PathParam(value="id") String id) {
        try (Jedis jedis = pool.getResource();){
            String json = jedis.get("petstore:pet:id." + id);
            if (json == null || json.isEmpty()) {
                Response response = Response.status(Response.Status.NOT_FOUND).build();
                return response;
            }
            log.info("Got pet");
            Response response = Response.status(Response.Status.OK).entity(new Gson().fromJson(json, Pet.class)).build();
            return response;
        }
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @Timed
    public List<Pet> getAllPets() {
        ArrayList<Pet> result = new ArrayList<Pet>();
        try (Jedis jedis = pool.getResource();){
            Set<String> categories = jedis.smembers("petstore:pet:categories");
            for (String category : categories) {
                Set<String> pets = jedis.smembers("petstore:pet:category." + category);
                for (String petID : pets) {
                    String petValue = jedis.get("petstore:pet:id." + petID);
                    result.add(new Gson().fromJson(petValue, Pet.class));
                }
            }
            ArrayList<Pet> arrayList = result;
            return arrayList;
        }
    }

    static {
        log.info("Using Redis master:" + REDIS_MASTER_HOST + ":" + REDIS_MASTER_PORT);
        pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), REDIS_MASTER_HOST, REDIS_MASTER_PORT);
    }
}

