/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.engine.config;

import org.wso2.carbon.config.ConfigurationUtils;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.config.annotation.Element;
import org.wso2.carbon.config.annotation.Ignore;
import org.wso2.carbon.deployment.engine.config.DeploymentModeEnum;
import org.wso2.carbon.deployment.engine.config.DeploymentNotifierConfig;

@Configuration(namespace="wso2.artifact.deployment", description="Deployment configuration parameters")
public class DeploymentConfiguration {
    @Element(description="deployment mode")
    private DeploymentModeEnum mode = DeploymentModeEnum.scheduled;
    @Element(description="server repository location")
    private String serverRepositoryLocation = "${carbon.home}/deployment/";
    @Ignore
    private String runtimeRepositoryLocation = "${wso2.runtime.path}/deployment/";
    @Element(description="Scheduler update interval")
    private int updateInterval = 15;
    @Element(description="Deployment notifier config")
    private DeploymentNotifierConfig deploymentNotifier = new DeploymentNotifierConfig();

    public DeploymentConfiguration() {
        this.serverRepositoryLocation = ConfigurationUtils.substituteVariables(this.serverRepositoryLocation);
        this.runtimeRepositoryLocation = ConfigurationUtils.substituteVariables(this.runtimeRepositoryLocation);
    }

    public DeploymentModeEnum getMode() {
        return this.mode;
    }

    public String getServerRepositoryLocation() {
        return this.serverRepositoryLocation;
    }

    public String getRuntimeRepositoryLocation() {
        return this.runtimeRepositoryLocation;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public DeploymentNotifierConfig getDeploymentNotifier() {
        return this.deploymentNotifier;
    }
}

