/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.internal.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;

public class WebSocketAsyncRemoteEndpoint
implements RemoteEndpoint.Async {
    private final ChannelHandlerContext ctx;

    public WebSocketAsyncRemoteEndpoint(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public long getSendTimeout() {
        return 0L;
    }

    @Override
    public void setSendTimeout(long timeoutmillis) {
    }

    @Override
    public void sendText(String text, SendHandler handler) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public ChannelFuture sendText(String text) {
        return this.ctx.channel().writeAndFlush(new TextWebSocketFrame(text));
    }

    public ChannelFuture sendBinary(ByteBuffer data) {
        ByteBuf byteBuf = Unpooled.wrappedBuffer(data);
        return this.ctx.channel().writeAndFlush(new BinaryWebSocketFrame(byteBuf));
    }

    @Override
    public void sendBinary(ByteBuffer data, SendHandler handler) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public ChannelFuture sendObject(Object data) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public void sendObject(Object data, SendHandler handler) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public void setBatchingAllowed(boolean allowed) throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public boolean getBatchingAllowed() {
        return false;
    }

    @Override
    public void flushBatch() throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        ByteBuf applicationDataBuf = Unpooled.wrappedBuffer(applicationData);
        this.ctx.channel().writeAndFlush(new PingWebSocketFrame(applicationDataBuf));
    }

    @Override
    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        ByteBuf applicationDataBuf = Unpooled.wrappedBuffer(applicationData);
        this.ctx.channel().writeAndFlush(new PongWebSocketFrame(applicationDataBuf));
    }
}

