/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.tracing;

import java.util.Date;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.analytics.common.tracing.TraceEvent;
import org.wso2.msf4j.analytics.common.tracing.TracingEventTracker;
import org.wso2.msf4j.analytics.common.tracing.TracingUtil;

public class MSF4JTracingInterceptor
implements Interceptor {
    private static final String RESPONDER_ATTRIBUTE = "responder-attribute";
    private static final String TRACE_EVENT_ATTRIBUTE = "trace-event-attribute";
    private String instanceId = TracingUtil.generateUniqueId();
    private String instanceName;
    private String dasUrl;

    public MSF4JTracingInterceptor(String microServiceName) {
        this(microServiceName, "http://localhost:9763/endpoints/msf4jtracereceiver");
    }

    public MSF4JTracingInterceptor(String microServiceName, String dasUrl) {
        this.instanceName = microServiceName;
        this.dasUrl = dasUrl;
    }

    @Override
    public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) throws Exception {
        long time = new Date().getTime();
        serviceMethodInfo.setAttribute(RESPONDER_ATTRIBUTE, responder);
        String traceOriginId = request.getHeader("X-msf4j-trace-origin-id");
        String serverTraceId = traceOriginId == null ? (traceOriginId = TracingUtil.generateUniqueId()) : TracingUtil.generateUniqueId();
        String traceParentId = request.getHeader("X-msf4j-trace-id");
        TraceEvent serverTraceEvent = new TraceEvent("STS", serverTraceId, traceOriginId, time);
        serverTraceEvent.setInstanceId(this.instanceId);
        serverTraceEvent.setInstanceName(this.instanceName);
        serverTraceEvent.setParentId(traceParentId);
        serverTraceEvent.setHttpMethod(request.getHttpMethod());
        serverTraceEvent.setUrl(request.getUri());
        TracingEventTracker.setTraceEvent(serverTraceEvent);
        serviceMethodInfo.setAttribute(TRACE_EVENT_ATTRIBUTE, serverTraceEvent);
        TracingUtil.pushToDAS(serverTraceEvent, this.dasUrl);
        return true;
    }

    @Override
    public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) throws Exception {
        long time = new Date().getTime();
        TraceEvent traceEvent = (TraceEvent)serviceMethodInfo.getAttribute(TRACE_EVENT_ATTRIBUTE);
        if (traceEvent != null) {
            TraceEvent endTraceEvent = new TraceEvent("STE", traceEvent.getTraceId(), traceEvent.getOriginId(), time);
            Response responder = (Response)serviceMethodInfo.getAttribute(RESPONDER_ATTRIBUTE);
            endTraceEvent.setStatusCode(responder.getStatusCode());
            TracingUtil.pushToDAS(endTraceEvent, this.dasUrl);
        }
    }
}

