/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.common.tracing;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.analytics.common.tracing.TraceEvent;

public class TracingUtil {
    private static final Logger log = LoggerFactory.getLogger(TracingUtil.class);
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static final Random random = new Random();

    public static String generateUniqueId() {
        return System.currentTimeMillis() + "" + String.format("%08d", random.nextInt(100000000));
    }

    public static void pushToDAS(TraceEvent traceEvent, String dasUrl) {
        Future<?> future = executorService.submit(() -> {
            log.debug("Publishing trace event " + traceEvent);
            if (ClientBuilder.newClient().target(dasUrl).request().post(Entity.json(traceEvent)).getStatus() != Response.Status.OK.getStatusCode()) {
                log.error("Error while publishing trace event " + traceEvent);
            }
        });
        future.isDone();
    }
}

