/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Requirement;
import net.jcip.annotations.Immutable;

@Immutable
public final class JWEAlgorithm
extends Algorithm {
    public static final JWEAlgorithm RSA1_5 = new JWEAlgorithm("RSA1_5", Requirement.REQUIRED);
    public static final JWEAlgorithm RSA_OAEP = new JWEAlgorithm("RSA-OAEP", Requirement.RECOMMENDED);
    public static final JWEAlgorithm A128KW = new JWEAlgorithm("A128KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm A192KW = new JWEAlgorithm("A192KW", Requirement.OPTIONAL);
    public static final JWEAlgorithm A256KW = new JWEAlgorithm("A256KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm DIR = new JWEAlgorithm("dir", Requirement.RECOMMENDED);
    public static final JWEAlgorithm ECDH_ES = new JWEAlgorithm("ECDH-ES", Requirement.RECOMMENDED);
    public static final JWEAlgorithm ECDH_ES_A128KW = new JWEAlgorithm("ECDH-ES+A128KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm ECDH_ES_A192KW = new JWEAlgorithm("ECDH-ES+A192KW", Requirement.OPTIONAL);
    public static final JWEAlgorithm ECDH_ES_A256KW = new JWEAlgorithm("ECDH-ES+A256KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm A128GCMKW = new JWEAlgorithm("A128GCMKW", Requirement.OPTIONAL);
    public static final JWEAlgorithm A192GCMKW = new JWEAlgorithm("A192GCMKW", Requirement.OPTIONAL);
    public static final JWEAlgorithm A256GCMKW = new JWEAlgorithm("A256GCMKW", Requirement.OPTIONAL);
    public static final JWEAlgorithm PBES2_HS256_A128KW = new JWEAlgorithm("PBES2-HS256+A128KW", Requirement.OPTIONAL);
    public static final JWEAlgorithm PBES2_HS256_A192KW = new JWEAlgorithm("PBES2-HS256+A192KW", Requirement.OPTIONAL);
    public static final JWEAlgorithm PBES2_HS256_A256KW = new JWEAlgorithm("PBES2-HS256+A256KW", Requirement.OPTIONAL);

    public JWEAlgorithm(String name, Requirement req) {
        super(name, req);
    }

    public JWEAlgorithm(String name) {
        super(name, null);
    }

    public static JWEAlgorithm parse(String s) {
        if (s.equals(RSA1_5.getName())) {
            return RSA1_5;
        }
        if (s.equals(RSA_OAEP.getName())) {
            return RSA_OAEP;
        }
        if (s.equals(A128KW.getName())) {
            return A128KW;
        }
        if (s.equals(A192KW.getName())) {
            return A192KW;
        }
        if (s.equals(A256KW.getName())) {
            return A256KW;
        }
        if (s.equals(DIR.getName())) {
            return DIR;
        }
        if (s.equals(ECDH_ES.getName())) {
            return ECDH_ES;
        }
        if (s.equals(ECDH_ES_A128KW.getName())) {
            return ECDH_ES_A128KW;
        }
        if (s.equals(ECDH_ES_A192KW.getName())) {
            return ECDH_ES_A192KW;
        }
        if (s.equals(ECDH_ES_A256KW.getName())) {
            return ECDH_ES_A256KW;
        }
        if (s.equals(A128GCMKW.getName())) {
            return A128GCMKW;
        }
        if (s.equals(A192GCMKW.getName())) {
            return A192GCMKW;
        }
        if (s.equals(A256GCMKW.getName())) {
            return A256GCMKW;
        }
        if (s.equals(PBES2_HS256_A128KW.getName())) {
            return PBES2_HS256_A128KW;
        }
        if (s.equals(PBES2_HS256_A192KW.getName())) {
            return PBES2_HS256_A192KW;
        }
        if (s.equals(PBES2_HS256_A256KW.getName())) {
            return PBES2_HS256_A256KW;
        }
        return new JWEAlgorithm(s);
    }
}

