/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.pet;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.annotation.Timed;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;
import org.wso2.msf4j.examples.petstore.util.model.Category;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@HTTPMonitored
@Path(value="/category")
public class PetCategoryService {
    private static final Logger log = LoggerFactory.getLogger(PetCategoryService.class);
    private static String REDIS_MASTER_HOST = System.getenv("REDIS_MASTER_HOST");
    private static int REDIS_MASTER_PORT = Integer.parseInt(System.getenv("REDIS_MASTER_PORT"));
    private static final JedisPool pool;

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response addCategory(Category category) {
        String name = category.getName();
        log.info("Using Redis master:" + REDIS_MASTER_HOST + ":" + REDIS_MASTER_PORT);
        try (Jedis jedis = pool.getResource();){
            jedis.sadd("petstore:pet:categories", name);
            log.info("Added category");
        }
        return Response.status(Response.Status.OK).entity("Category with name " + name + " successfully added").build();
    }

    @DELETE
    @Path(value="/{name}")
    @Timed
    public Response deleteCategory(@PathParam(value="name") String name) {
        try (Jedis jedis = pool.getResource();){
            if (!jedis.smembers("petstore:pet:categories").contains(name)) {
                Response response = Response.status(Response.Status.NOT_FOUND).build();
                return response;
            }
            String categoryKey = "petstore:pet:category." + name;
            jedis.srem("petstore:pet:categories", name);
            jedis.del(categoryKey);
            log.info("Deleted category: " + name);
        }
        return Response.status(Response.Status.OK).entity("OK").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{name}")
    @Timed
    public Response getCategory(@PathParam(value="name") String name) {
        try (Jedis jedis = pool.getResource();){
            if (!jedis.smembers("petstore:pet:categories").contains(name)) {
                Response response = Response.status(Response.Status.NOT_FOUND).build();
                return response;
            }
            log.info("Got category");
        }
        return Response.status(Response.Status.OK).entity(new Category(name)).build();
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @Timed
    public Set<Category> getAllCategories() {
        try (Jedis jedis = pool.getResource();){
            Set<String> smembers = jedis.smembers("petstore:pet:categories");
            HashSet<Category> categories = new HashSet<Category>(smembers.size());
            for (String smember : smembers) {
                categories.add(new Category(smember));
            }
            HashSet<Category> hashSet = categories;
            return hashSet;
        }
    }

    static {
        log.info("Using Redis master:" + REDIS_MASTER_HOST + ":" + REDIS_MASTER_PORT);
        pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), REDIS_MASTER_HOST, REDIS_MASTER_PORT);
    }
}

