/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.websocket;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.PongMessage;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.wso2.msf4j.internal.websocket.EndpointDispatcher;
import org.wso2.msf4j.websocket.exception.WebSocketEndpointAnnotationException;
import org.wso2.msf4j.websocket.exception.WebSocketEndpointMethodReturnTypeException;
import org.wso2.msf4j.websocket.exception.WebSocketMethodParameterException;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;

public class EndpointValidator {
    public boolean validate(Object webSocketEndpoint) throws WebSocketEndpointAnnotationException, WebSocketMethodParameterException, WebSocketEndpointMethodReturnTypeException {
        if (webSocketEndpoint == null) {
            return false;
        }
        return this.validateURI(webSocketEndpoint) && this.validateOnStringMethod(webSocketEndpoint) && this.validateOnBinaryMethod(webSocketEndpoint) && this.validateOnPongMethod(webSocketEndpoint) && this.validateOnOpenMethod(webSocketEndpoint) && this.validateOnCloseMethod(webSocketEndpoint) && this.validateOnErrorMethod(webSocketEndpoint);
    }

    private boolean validateURI(Object webSocketEndpoint) throws WebSocketEndpointAnnotationException {
        if (webSocketEndpoint.getClass().isAnnotationPresent(ServerEndpoint.class)) {
            return true;
        }
        throw new WebSocketEndpointAnnotationException("Server Endpoint is not defined.");
    }

    private boolean validateOnStringMethod(Object webSocketEndpoint) throws WebSocketMethodParameterException, WebSocketEndpointMethodReturnTypeException {
        EndpointDispatcher dispatcher = new EndpointDispatcher();
        if (!dispatcher.getOnStringMessageMethod(webSocketEndpoint).isPresent()) {
            return true;
        }
        Method method = dispatcher.getOnStringMessageMethod(webSocketEndpoint).get();
        this.validateReturnType(method);
        boolean foundPrimaryString = false;
        for (Parameter parameter : method.getParameters()) {
            Class<?> paraType = parameter.getType();
            if (paraType == String.class) {
                if (parameter.getAnnotation(PathParam.class) != null) continue;
                if (foundPrimaryString) {
                    throw new WebSocketMethodParameterException("Invalid parameter found on text message method: More than one string parameter without @PathParam annotation.");
                }
                foundPrimaryString = true;
                continue;
            }
            if (paraType == WebSocketConnection.class) continue;
            throw new WebSocketMethodParameterException("Invalid parameter found on text message method: " + paraType);
        }
        return foundPrimaryString;
    }

    private boolean validateOnBinaryMethod(Object webSocketEndpoint) throws WebSocketMethodParameterException, WebSocketEndpointMethodReturnTypeException {
        EndpointDispatcher dispatcher = new EndpointDispatcher();
        if (!dispatcher.getOnBinaryMessageMethod(webSocketEndpoint).isPresent()) {
            return true;
        }
        Method method = dispatcher.getOnBinaryMessageMethod(webSocketEndpoint).get();
        this.validateReturnType(method);
        boolean foundPrimaryBuffer = false;
        boolean foundIsFinal = false;
        for (Parameter parameter : method.getParameters()) {
            Class<?> paraType = parameter.getType();
            if (paraType == String.class) {
                if (parameter.getAnnotation(PathParam.class) != null) continue;
                throw new WebSocketMethodParameterException("Invalid parameter found on binary message method: string parameter without @PathParam annotation.");
            }
            if (paraType == ByteBuffer.class || paraType == byte[].class) {
                if (foundPrimaryBuffer) {
                    throw new WebSocketMethodParameterException("Invalid parameter found on binary message method: only one ByteBuffer/byte[] should be declared.");
                }
                foundPrimaryBuffer = true;
                continue;
            }
            if (paraType == Boolean.TYPE) {
                if (foundIsFinal) {
                    throw new WebSocketMethodParameterException("Invalid parameter found on binary message method: only one boolean should be declared and found more than one.");
                }
                foundIsFinal = true;
                continue;
            }
            if (paraType == WebSocketConnection.class) continue;
            throw new WebSocketMethodParameterException("Invalid parameter found on binary message method: " + paraType);
        }
        return foundPrimaryBuffer;
    }

    private boolean validateOnPongMethod(Object webSocketEndpoint) throws WebSocketMethodParameterException, WebSocketEndpointMethodReturnTypeException {
        EndpointDispatcher dispatcher = new EndpointDispatcher();
        if (!dispatcher.getOnPongMessageMethod(webSocketEndpoint).isPresent()) {
            return true;
        }
        Method method = dispatcher.getOnPongMessageMethod(webSocketEndpoint).get();
        this.validateReturnType(method);
        boolean foundPrimaryPong = false;
        for (Parameter parameter : method.getParameters()) {
            Class<?> paraType = parameter.getType();
            if (paraType == String.class) {
                if (parameter.getAnnotation(PathParam.class) != null) continue;
                throw new WebSocketMethodParameterException("Invalid parameter found on pong message method: string parameter without @PathParam annotation.");
            }
            if (paraType == PongMessage.class) {
                if (foundPrimaryPong) {
                    throw new WebSocketMethodParameterException("Invalid parameter found on pong message method: only one PongMessage should be declared.");
                }
                foundPrimaryPong = true;
                continue;
            }
            if (paraType == WebSocketConnection.class) continue;
            throw new WebSocketMethodParameterException("Invalid parameter found on pong message method: " + paraType);
        }
        return foundPrimaryPong;
    }

    private boolean validateOnOpenMethod(Object webSocketEndpoint) throws WebSocketMethodParameterException, WebSocketEndpointMethodReturnTypeException {
        EndpointDispatcher dispatcher = new EndpointDispatcher();
        if (!dispatcher.getOnOpenMethod(webSocketEndpoint).isPresent()) {
            return true;
        }
        Method method = dispatcher.getOnOpenMethod(webSocketEndpoint).get();
        this.validateReturnType(method);
        for (Parameter parameter : method.getParameters()) {
            Class<?> paraType = parameter.getType();
            if (paraType == String.class) {
                if (parameter.getAnnotation(PathParam.class) != null) continue;
                throw new WebSocketMethodParameterException("Invalid parameter found on open message method: string parameter without @PathParam annotation.");
            }
            if (paraType == WebSocketConnection.class || paraType == HttpCarbonRequest.class) continue;
            throw new WebSocketMethodParameterException("Invalid parameter found on open message method: " + paraType);
        }
        return true;
    }

    private boolean validateOnCloseMethod(Object webSocketEndpoint) throws WebSocketMethodParameterException, WebSocketEndpointMethodReturnTypeException {
        EndpointDispatcher dispatcher = new EndpointDispatcher();
        if (!dispatcher.getOnCloseMethod(webSocketEndpoint).isPresent()) {
            return true;
        }
        Method method = dispatcher.getOnCloseMethod(webSocketEndpoint).get();
        this.validateReturnType(method);
        for (Parameter parameter : method.getParameters()) {
            Class<?> paraType = parameter.getType();
            if (paraType == String.class) {
                if (parameter.getAnnotation(PathParam.class) != null) continue;
                throw new WebSocketMethodParameterException("Invalid parameter found on close message method: string parameter without @PathParam annotation.");
            }
            if (paraType == CloseReason.class || paraType == WebSocketConnection.class) continue;
            throw new WebSocketMethodParameterException("Invalid parameter found on close message method: " + paraType);
        }
        return true;
    }

    private boolean validateOnErrorMethod(Object webSocketEndpoint) throws WebSocketMethodParameterException, WebSocketEndpointMethodReturnTypeException {
        EndpointDispatcher dispatcher = new EndpointDispatcher();
        if (!dispatcher.getOnErrorMethod(webSocketEndpoint).isPresent()) {
            return true;
        }
        Method method = dispatcher.getOnErrorMethod(webSocketEndpoint).get();
        this.validateReturnType(method);
        boolean foundPrimaryThrowable = false;
        for (Parameter parameter : method.getParameters()) {
            Class<?> paraType = parameter.getType();
            if (paraType == String.class) {
                if (parameter.getAnnotation(PathParam.class) != null) continue;
                throw new WebSocketMethodParameterException("Invalid parameter found on error message method: string parameter without @PathParam annotation.");
            }
            if (paraType == Throwable.class) {
                if (foundPrimaryThrowable) {
                    throw new WebSocketMethodParameterException("Invalid parameter found on pong message method: only one Throwable should be declared.");
                }
                foundPrimaryThrowable = true;
                continue;
            }
            if (paraType == WebSocketConnection.class) continue;
            throw new WebSocketMethodParameterException("Invalid parameter found on error message method: " + paraType);
        }
        if (!foundPrimaryThrowable) {
            throw new WebSocketMethodParameterException("Mandatory parameter for on error method " + Throwable.class + " not found.");
        }
        return foundPrimaryThrowable;
    }

    private boolean validateReturnType(Method method) throws WebSocketEndpointMethodReturnTypeException {
        boolean foundCorrectReturnType;
        Class<?> returnType = method.getReturnType();
        boolean bl = foundCorrectReturnType = returnType == String.class || returnType == ByteBuffer.class || returnType == byte[].class || returnType == PongMessage.class || returnType == Void.TYPE;
        if (!foundCorrectReturnType) {
            throw new WebSocketEndpointMethodReturnTypeException("Unexpected method return type: " + returnType);
        }
        return foundCorrectReturnType;
    }
}

