/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.RegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.exception.LdapOtherException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.SchemaObjectWrapper;
import org.apache.directory.shared.ldap.schema.loader.ldif.SchemaEntityFactory;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegistrySynchronizer
implements RegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRegistrySynchronizer.class);
    protected final SchemaManager schemaManager;
    protected final AttributeType m_oidAT;
    protected final SchemaEntityFactory factory;
    private static final Map<String, String> OBJECT_TYPE_TO_PATH = new HashMap<String, String>();

    protected AbstractRegistrySynchronizer(SchemaManager schemaManager) throws Exception {
        this.schemaManager = schemaManager;
        this.m_oidAT = schemaManager.lookupAttributeTypeRegistry("m-oid");
        this.factory = new SchemaEntityFactory();
    }

    protected boolean isSchemaLoaded(DN dn) throws Exception {
        return this.schemaManager.isSchemaLoaded(this.getSchemaName(dn));
    }

    protected boolean isSchemaLoaded(String schemaName) {
        return this.schemaManager.isSchemaLoaded(schemaName);
    }

    protected boolean isSchemaEnabled(String schemaName) {
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        return schema != null && schema.isEnabled();
    }

    protected String getSchemaName(DN dn) throws NamingException {
        if (dn.size() < 2) {
            throw new NamingException(I18n.err(I18n.ERR_276, new Object[0]));
        }
        RDN rdn = dn.getRdn(1);
        return rdn.getNormValue();
    }

    protected void checkOidIsUnique(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.schemaManager.getGlobalOidRegistry().contains(oid)) {
            throw new LdapOtherException(I18n.err(I18n.ERR_335, oid));
        }
    }

    protected SchemaObject checkOidExists(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.schemaManager.getGlobalOidRegistry().contains(oid)) {
            return this.schemaManager.getGlobalOidRegistry().getSchemaObject(oid);
        }
        throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_336, oid));
    }

    protected void checkParent(DN newParent, SchemaManager schemaManager, String objectType) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_337, new Object[0]));
        }
        RDN rdn = newParent.getRdn();
        if (!schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_338, objectType));
        }
        if (!rdn.getNormValue().equalsIgnoreCase(OBJECT_TYPE_TO_PATH.get(objectType))) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_339, objectType, OBJECT_TYPE_TO_PATH.get(objectType)));
        }
    }

    protected void checkOidIsUnique(SchemaObject schemaObject) throws Exception {
        String oid = schemaObject.getOid();
        if (this.schemaManager.getGlobalOidRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_335, oid));
        }
    }

    protected void checkOidIsUnique(String oid) throws Exception {
        if (this.schemaManager.getGlobalOidRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_335, oid));
        }
    }

    protected void addToSchema(SchemaObject schemaObject, String schemaName) throws Exception {
        SchemaObjectWrapper schemaObjectWrapper;
        Set<SchemaObjectWrapper> schemaObjects;
        if (this.isSchemaLoaded(schemaName)) {
            schemaObjects = this.schemaManager.getRegistries().getObjectBySchemaName().get(schemaName);
            if (schemaObjects == null) {
                schemaObjects = this.schemaManager.getRegistries().addSchema(schemaName);
            }
            if (schemaObjects.contains(schemaObjectWrapper = new SchemaObjectWrapper(schemaObject))) {
                String msg = I18n.err(I18n.ERR_341, schemaObject.getName(), schemaName);
                LOG.warn(msg);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
        } else {
            String msg = I18n.err(I18n.ERR_342, schemaObject.getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        schemaObjects.add(schemaObjectWrapper);
        LOG.debug("The SchemaObject {} has been added to the schema {}", (Object)schemaObject, (Object)schemaName);
    }

    protected void deleteFromSchema(SchemaObject schemaObject, String schemaName) throws Exception {
        SchemaObjectWrapper schemaObjectWrapper;
        Set<SchemaObjectWrapper> schemaObjects;
        if (this.isSchemaLoaded(schemaName)) {
            schemaObjects = this.schemaManager.getRegistries().getObjectBySchemaName().get(schemaName);
            if (!schemaObjects.contains(schemaObjectWrapper = new SchemaObjectWrapper(schemaObject))) {
                String msg = I18n.err(I18n.ERR_343, schemaObject.getName(), schemaName);
                LOG.warn(msg);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
        } else {
            String msg = I18n.err(I18n.ERR_342, schemaObject.getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        schemaObjects.remove(schemaObjectWrapper);
        LOG.debug("The SchemaObject {} has been removed from the schema {}", (Object)schemaObject, (Object)schemaName);
    }

    @Override
    public abstract boolean modify(ModifyOperationContext var1, ServerEntry var2, boolean var3) throws Exception;

    protected Set<String> getOids(Set<ServerEntry> results) throws Exception {
        HashSet<String> oids = new HashSet<String>(results.size());
        for (ServerEntry result : results) {
            DN dn = result.getDn();
            dn.normalize(this.schemaManager.getNormalizerMapping());
            oids.add(dn.getRdn().getNormValue());
        }
        return oids;
    }

    protected String getOid(ServerEntry entry) throws Exception {
        EntryAttribute oid = entry.get(this.m_oidAT);
        if (oid == null) {
            return null;
        }
        return oid.getString();
    }

    protected void unregisterOids(SchemaObject obj) throws Exception {
        this.schemaManager.getGlobalOidRegistry().unregister(obj.getOid());
    }

    protected void registerOids(SchemaObject obj) throws Exception {
        this.schemaManager.getGlobalOidRegistry().register(obj);
    }

    protected String getReferenced(SchemaObject schemaObject) {
        StringBuilder sb = new StringBuilder();
        Set<SchemaObjectWrapper> useds = this.schemaManager.getRegistries().getUsedBy(schemaObject);
        for (SchemaObjectWrapper used : useds) {
            sb.append(used);
            sb.append('\n');
        }
        return sb.toString();
    }

    static {
        OBJECT_TYPE_TO_PATH.put("AttributeType", "ou=attributetypes".substring(3));
        OBJECT_TYPE_TO_PATH.put("Comparator", "ou=comparators".substring(3));
        OBJECT_TYPE_TO_PATH.put("DitContentRule", "ou=ditcontentrules".substring(3));
        OBJECT_TYPE_TO_PATH.put("DitStructureRule", "ou=ditstructurerules".substring(3));
        OBJECT_TYPE_TO_PATH.put("MatchingRule", "ou=matchingrules".substring(3));
        OBJECT_TYPE_TO_PATH.put("MatchingRuleUse", "ou=matchingruleuse".substring(3));
        OBJECT_TYPE_TO_PATH.put("NameForm", "ou=nameforms".substring(3));
        OBJECT_TYPE_TO_PATH.put("Normalizer", "ou=normalizers".substring(3));
        OBJECT_TYPE_TO_PATH.put("ObjectCLass", "ou=objectclasses".substring(3));
        OBJECT_TYPE_TO_PATH.put("Syntax", "ou=syntaxes".substring(3));
        OBJECT_TYPE_TO_PATH.put("SyntaxChecker", "ou=syntaxcheckers".substring(3));
    }
}

