/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.grammar;

import org.apache.directory.shared.asn1.ber.grammar.IAction;
import org.apache.directory.shared.asn1.ber.grammar.IStates;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;

public class GrammarTransition {
    private IAction action;
    private int previousState;
    private int currentState;
    private int currentTag;

    public GrammarTransition(int previousState, int currentState, int currentTag, IAction action) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.action = action;
        this.currentTag = currentTag;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public IAction getAction() {
        return this.action;
    }

    public String toString(IStates statesEnum) {
        StringBuffer sb = new StringBuffer();
        sb.append("Transition from state <").append(statesEnum.getState(this.previousState)).append("> ");
        sb.append("to state <").append(statesEnum.getState(this.currentState)).append(">, ");
        sb.append("tag <").append(Asn1StringUtils.dumpByte((byte)this.currentTag)).append(">, ");
        sb.append("action : ").append(this.action == null ? "no action" : this.action.toString()).append(">");
        return sb.toString();
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public int getPreviousState() {
        return this.previousState;
    }
}

