/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.DnParser;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DN
implements Cloneable,
Serializable,
Comparable<DN>,
Iterable<RDN> {
    protected static final Logger LOG = LoggerFactory.getLogger(DN.class);
    private static final long serialVersionUID = 1L;
    public static final int NOT_EQUAL = -1;
    public static final int EQUAL = 0;
    private boolean normalized;
    protected List<RDN> rdns = new ArrayList<RDN>(5);
    private String upName;
    private String normName;
    private byte[] bytes;
    public static final DN EMPTY_DN = new DN();

    public DN() {
        this.upName = "";
        this.normName = null;
        this.normalized = true;
    }

    public DN(DN dn) throws LdapInvalidDnException {
        if (dn != null && dn.size() != 0) {
            for (int ii = 0; ii < dn.size(); ++ii) {
                String nameComponent = dn.get(ii);
                this.add(nameComponent);
            }
        }
        this.normalized = false;
    }

    public DN(String upName) throws LdapInvalidDnException {
        if (upName != null) {
            DnParser.parseInternal(upName, this.rdns);
        }
        this.normalizeInternal();
        this.normalized = false;
        this.upName = upName;
    }

    public DN(String ... upRdns) throws LdapInvalidDnException {
        StringBuilder sb = new StringBuilder();
        boolean valueExpected = false;
        boolean isFirst = true;
        for (String upRdn : upRdns) {
            if (isFirst) {
                isFirst = false;
            } else if (!valueExpected) {
                sb.append(',');
            }
            if (!valueExpected) {
                sb.append(upRdn);
                if (upRdn.indexOf(61) != -1) continue;
                valueExpected = true;
                continue;
            }
            sb.append("=").append(upRdn);
            valueExpected = false;
        }
        if (valueExpected) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04202", new Object[0]));
        }
        this.upName = sb.toString();
        DnParser.parseInternal(this.upName, this.rdns);
        this.normalizeInternal();
        this.normalized = false;
    }

    DN(String upName, String normName, byte[] bytes) {
        this.normalized = true;
        this.upName = upName;
        this.normName = normName;
        this.bytes = bytes;
    }

    public static DN normalize(String name, Map<String, OidNormalizer> oidsMap) throws LdapInvalidDnException {
        if (name == null || name.length() == 0 || oidsMap == null || oidsMap.size() == 0) {
            return EMPTY_DN;
        }
        DN newDn = new DN(name);
        Enumeration<RDN> rdns = newDn.getAllRdn();
        while (rdns.hasMoreElements()) {
            RDN rdn = rdns.nextElement();
            String upName = rdn.getName();
            DN.rdnOidToName(rdn, oidsMap);
            rdn.normalize();
            rdn.setUpName(upName);
        }
        newDn.normalizeInternal();
        newDn.normalized = true;
        return newDn;
    }

    void normalizeInternal() {
        this.normName = this.toNormName();
    }

    private String toNormName() {
        if (this.rdns.size() == 0) {
            this.bytes = null;
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (RDN rdn : this.rdns) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(rdn.getNormName());
        }
        String newNormName = sb.toString();
        if (this.normName == null || !this.normName.equals(newNormName)) {
            this.bytes = StringTools.getBytesUtf8(newNormName);
            this.normName = newNormName;
        }
        return this.normName;
    }

    public String toString() {
        return this.getName();
    }

    private String toUpName() {
        if (this.rdns.size() == 0) {
            this.upName = "";
        } else {
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (RDN rdn : this.rdns) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(rdn.getName());
            }
            this.upName = sb.toString();
        }
        return this.upName;
    }

    private String getUpNamePrefix(int posn) {
        if (posn == 0) {
            return "";
        }
        if (posn > this.rdns.size()) {
            String message = I18n.err("ERR_04203", posn, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        int start = this.rdns.size() - posn;
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (int i = start; i < this.rdns.size(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(this.rdns.get(i).getName());
        }
        return sb.toString();
    }

    private String getUpNameSuffix(int posn) {
        if (posn > this.rdns.size()) {
            return "";
        }
        int end = this.rdns.size() - posn;
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < end; ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(this.rdns.get(i).getName());
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 37;
        for (RDN rdn : this.rdns) {
            result = result * 17 + rdn.hashCode();
        }
        return result;
    }

    public String getName() {
        return this.upName == null ? "" : this.upName;
    }

    void setUpName(String upName) {
        this.upName = upName;
    }

    public String getNormName() {
        if (this.normName == null) {
            this.normName = this.toNormName();
        }
        return this.normName;
    }

    public int size() {
        return this.rdns.size();
    }

    public static int getNbBytes(DN dn) {
        return dn.bytes == null ? 0 : dn.bytes.length;
    }

    public static byte[] getBytes(DN dn) {
        return dn == null ? null : dn.bytes;
    }

    public boolean isParentOf(String dn) {
        try {
            return this.isParentOf(new DN(dn));
        }
        catch (LdapInvalidDnException lide) {
            return false;
        }
    }

    public boolean isParentOf(DN dn) {
        if (dn == null) {
            return false;
        }
        return dn.isChildOf(this);
    }

    public boolean isChildOf(String dn) {
        try {
            return this.isChildOf(new DN(dn));
        }
        catch (LdapInvalidDnException lide) {
            return false;
        }
    }

    public boolean isChildOf(DN dn) {
        if (dn == null) {
            return true;
        }
        if (dn.size() == 0) {
            return true;
        }
        if (dn.size() > this.size()) {
            return false;
        }
        for (int i = dn.size() - 1; i >= 0; --i) {
            RDN ldapRdn;
            RDN nameRdn = dn.rdns.get(dn.rdns.size() - i - 1);
            if (nameRdn.compareTo(ldapRdn = this.rdns.get(this.rdns.size() - i - 1)) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean hasSuffix(DN dn) {
        if (dn == null) {
            return true;
        }
        if (dn.size() == 0) {
            return true;
        }
        if (dn.size() > this.size()) {
            return false;
        }
        for (int i = 0; i < dn.size(); ++i) {
            RDN ldapRdn;
            RDN nameRdn = dn.rdns.get(i);
            if (nameRdn.compareTo(ldapRdn = this.rdns.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.rdns.size() == 0;
    }

    public String get(int posn) {
        if (this.rdns.size() == 0) {
            return "";
        }
        RDN rdn = this.rdns.get(this.rdns.size() - posn - 1);
        return rdn.getNormName();
    }

    public RDN getRdn(int posn) {
        if (this.rdns.size() == 0) {
            return null;
        }
        RDN rdn = this.rdns.get(this.rdns.size() - posn - 1);
        return rdn;
    }

    public RDN getRdn() {
        if (this.rdns.size() == 0) {
            return null;
        }
        return this.rdns.get(0);
    }

    public List<RDN> getRdns() {
        ArrayList<RDN> newRdns = new ArrayList<RDN>();
        for (RDN rdn : this.rdns) {
            newRdns.add((RDN)rdn.clone());
        }
        return newRdns;
    }

    public Enumeration<RDN> getAllRdn() {
        return new Enumeration<RDN>(){
            private int pos;

            @Override
            public boolean hasMoreElements() {
                return this.pos < DN.this.rdns.size();
            }

            @Override
            public RDN nextElement() {
                if (this.pos >= DN.this.rdns.size()) {
                    LOG.error(I18n.err("ERR_04205", new Object[0]));
                    throw new NoSuchElementException();
                }
                RDN rdn = DN.this.rdns.get(DN.this.rdns.size() - this.pos - 1);
                ++this.pos;
                return rdn;
            }
        };
    }

    public DN getPrefix(int posn) {
        if (this.rdns.size() == 0) {
            return EMPTY_DN;
        }
        if (posn < 0 || posn > this.rdns.size()) {
            String message = I18n.err("ERR_04206", posn, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        DN newDN = new DN();
        for (int i = this.rdns.size() - posn; i < this.rdns.size(); ++i) {
            newDN.rdns.add((RDN)this.rdns.get(i).clone());
        }
        newDN.normName = newDN.toNormName();
        newDN.upName = this.getUpNamePrefix(posn);
        return newDN;
    }

    public DN getSuffix(int posn) {
        if (this.rdns.size() == 0) {
            return EMPTY_DN;
        }
        if (posn < 0 || posn > this.rdns.size()) {
            String message = I18n.err("ERR_04206", posn, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        DN newDN = new DN();
        for (int i = 0; i < this.size() - posn; ++i) {
            newDN.rdns.add((RDN)this.rdns.get(i).clone());
        }
        newDN.normName = newDN.toNormName();
        newDN.upName = this.getUpNameSuffix(posn);
        return newDN;
    }

    public DN addAllNormalized(int posn, DN name) throws LdapInvalidDnException {
        if (name instanceof DN) {
            DN dn = name;
            if (dn == null || dn.size() == 0) {
                return this;
            }
            this.rdns.addAll(this.size() - posn, dn.rdns);
            if (StringTools.isEmpty(this.normName)) {
                this.normName = dn.normName;
                this.bytes = dn.bytes;
                this.upName = dn.upName;
            } else {
                this.normName = dn.normName + "," + this.normName;
                this.bytes = StringTools.getBytesUtf8(this.normName);
                this.upName = dn.upName + "," + this.upName;
            }
        } else {
            if (name == null || name.size() == 0) {
                return this;
            }
            for (int i = name.size() - 1; i >= 0; --i) {
                RDN rdn = new RDN(name.get(i));
                this.rdns.add(this.size() - posn, rdn);
            }
            this.normalizeInternal();
            this.toUpName();
        }
        return this;
    }

    public DN addAll(DN suffix) throws LdapInvalidDnException {
        this.addAll(this.rdns.size(), suffix);
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public DN addAll(int posn, Name name) throws InvalidNameException, LdapInvalidDnException {
        if (name == null || name.size() == 0) {
            return this;
        }
        for (int i = name.size() - 1; i >= 0; --i) {
            RDN rdn = new RDN(name.get(i));
            this.rdns.add(this.size() - posn, rdn);
        }
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public DN addAll(int posn, DN dn) throws LdapInvalidDnException {
        if (dn == null || dn.size() == 0) {
            return this;
        }
        this.rdns.addAll(this.size() - posn, dn.rdns);
        if (this.isNormalized() && dn.isNormalized()) {
            if (this.size() != 0) {
                this.normName = dn.getNormName() + "," + this.normName;
                this.bytes = StringTools.getBytesUtf8(this.normName);
                this.upName = dn.getName() + "," + this.upName;
            }
        } else {
            this.normalizeInternal();
            this.toUpName();
        }
        return this;
    }

    public DN add(String comp) throws LdapInvalidDnException {
        if (comp.length() == 0) {
            return this;
        }
        try {
            RDN newRdn = new RDN(comp);
            this.rdns.add(0, newRdn);
        }
        catch (LdapInvalidDnException le) {
            throw new LdapInvalidDnException(le.getMessage());
        }
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public DN add(RDN newRdn) {
        this.rdns.add(0, newRdn);
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public DN add(int pos, RDN newRdn) {
        this.rdns.add(newRdn);
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public DN addNormalized(RDN newRdn) {
        this.rdns.add(0, newRdn);
        if (this.rdns.size() == 1) {
            this.normName = newRdn.getNormName();
            this.upName = newRdn.getName();
        } else {
            this.normName = newRdn + "," + this.normName;
            this.upName = newRdn.getName() + "," + this.upName;
        }
        this.bytes = StringTools.getBytesUtf8(this.normName);
        return this;
    }

    public DN add(int posn, String comp) throws LdapInvalidDnException {
        if (posn < 0 || posn > this.size()) {
            String message = I18n.err("ERR_04206", posn, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        try {
            RDN newRdn = new RDN(comp);
            int realPos = this.size() - posn;
            this.rdns.add(realPos, newRdn);
        }
        catch (LdapInvalidDnException le) {
            throw new LdapInvalidDnException(le.getMessage());
        }
        this.normalizeInternal();
        this.toUpName();
        return this;
    }

    public RDN remove(int posn) throws LdapInvalidDnException {
        if (this.rdns.size() == 0) {
            return RDN.EMPTY_RDN;
        }
        if (posn < 0 || posn >= this.rdns.size()) {
            String message = I18n.err("ERR_04206", posn, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        int realPos = this.size() - posn - 1;
        RDN rdn = this.rdns.remove(realPos);
        this.normalizeInternal();
        this.toUpName();
        return rdn;
    }

    public Object clone() {
        try {
            DN dn = (DN)super.clone();
            dn.rdns = new ArrayList<RDN>();
            for (RDN rdn : this.rdns) {
                dn.rdns.add((RDN)rdn.clone());
            }
            return dn;
        }
        catch (CloneNotSupportedException cnse) {
            LOG.error(I18n.err("ERR_04207", new Object[0]));
            throw new Error(I18n.err("ERR_04208", new Object[0]));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.normName.equals(obj);
        }
        if (obj instanceof DN) {
            DN name = (DN)obj;
            if (name.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (name.rdns.get(i).compareTo(this.rdns.get(i)) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(DN dn) {
        if (dn.size() != this.size()) {
            return this.size() - dn.size();
        }
        for (int i = this.rdns.size(); i > 0; --i) {
            RDN rdn2;
            RDN rdn1 = this.rdns.get(i - 1);
            int res = rdn1.compareTo(rdn2 = dn.rdns.get(i - 1));
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    private static AVA atavOidToName(AVA atav, Map<String, OidNormalizer> oidsMap) throws LdapInvalidDnException {
        String type = StringTools.trim(atav.getNormType());
        if (type.startsWith("oid.") || type.startsWith("OID.")) {
            type = type.substring(4);
        }
        if (StringTools.isNotEmpty(type)) {
            if (oidsMap == null) {
                return atav;
            }
            OidNormalizer oidNormalizer = oidsMap.get(type.toLowerCase());
            if (oidNormalizer != null) {
                try {
                    return new AVA(atav.getUpType(), oidNormalizer.getAttributeTypeOid(), atav.getUpValue(), oidNormalizer.getNormalizer().normalize(atav.getNormValue()), atav.getUpName());
                }
                catch (LdapException le) {
                    throw new LdapInvalidDnException(le.getMessage());
                }
            }
            return atav;
        }
        LOG.error(I18n.err("ERR_04209", new Object[0]));
        throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err("ERR_04209", new Object[0]));
    }

    static void rdnOidToName(RDN rdn, Map<String, OidNormalizer> oidsMap) throws LdapInvalidDnException {
        if (rdn.getNbAtavs() > 1) {
            RDN rdnCopy = (RDN)rdn.clone();
            rdn.clear();
            for (AVA val : rdnCopy) {
                AVA newAtav = DN.atavOidToName(val, oidsMap);
                rdn.addAttributeTypeAndValue(newAtav);
            }
        } else {
            AVA val = rdn.getAtav();
            rdn.clear();
            AVA newAtav = DN.atavOidToName(val, oidsMap);
            rdn.addAttributeTypeAndValue(newAtav);
        }
    }

    public static DN normalize(DN dn, Map<String, OidNormalizer> oidsMap) throws LdapInvalidDnException {
        if (dn == null || dn.size() == 0 || oidsMap == null || oidsMap.size() == 0) {
            return dn;
        }
        Enumeration<RDN> rdns = dn.getAllRdn();
        while (rdns.hasMoreElements()) {
            RDN rdn = rdns.nextElement();
            String upName = rdn.getName();
            DN.rdnOidToName(rdn, oidsMap);
            rdn.normalize();
            rdn.setUpName(upName);
        }
        dn.normalizeInternal();
        dn.normalized = true;
        return dn;
    }

    public DN normalize(Map<String, OidNormalizer> oidsMap) throws LdapInvalidDnException {
        if (oidsMap == null || oidsMap.size() == 0) {
            return this;
        }
        if (this.size() == 0) {
            this.normalized = true;
            return this;
        }
        Enumeration<RDN> localRdns = this.getAllRdn();
        while (localRdns.hasMoreElements()) {
            RDN rdn = localRdns.nextElement();
            String localUpName = rdn.getName();
            DN.rdnOidToName(rdn, oidsMap);
            rdn.normalize();
            rdn.setUpName(localUpName);
        }
        this.normalizeInternal();
        this.normalized = true;
        return this;
    }

    public static boolean isValid(String dn) {
        return DnParser.validateInternal(dn);
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.upName == null) {
            String message = I18n.err("ERR_04210", new Object[0]);
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(this.upName);
        if (this.isNormalized()) {
            if (this.upName.equals(this.normName)) {
                out.writeUTF("");
            } else {
                out.writeUTF(this.normName);
            }
        } else {
            String message = I18n.err("ERR_04211", new Object[0]);
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeInt(this.rdns.size());
        for (RDN rdn : this.rdns) {
            out.writeObject(rdn);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.upName = in.readUTF();
        this.normName = in.readUTF();
        if (this.normName.length() == 0) {
            this.normName = this.upName;
        }
        this.normalized = true;
        this.bytes = StringTools.getBytesUtf8(this.upName);
        int nbRdns = in.readInt();
        this.rdns = new ArrayList<RDN>(nbRdns);
        for (int i = 0; i < nbRdns; ++i) {
            RDN rdn = (RDN)in.readObject();
            this.rdns.add(rdn);
        }
    }

    public static DN fromName(Name name) {
        try {
            DN dn = new DN(name.toString());
            return dn;
        }
        catch (LdapInvalidDnException lide) {
            return null;
        }
    }

    public static Name toName(DN dn) {
        try {
            LdapName name = new LdapName(dn.toString());
            return name;
        }
        catch (InvalidNameException ine) {
            return null;
        }
    }

    @Override
    public Iterator<RDN> iterator() {
        return this.rdns.iterator();
    }
}

