/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint.thrift;

import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.client.AbstractClientPoolFactory;
import org.wso2.carbon.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.commons.thrift.service.general.ThriftEventTransmissionService;

public class ThriftClientPoolFactory
extends AbstractClientPoolFactory {
    @Override
    public Object createClient(String protocol, String hostName, int port) throws DataEndpointException, DataEndpointAgentConfigurationException {
        if (protocol.equalsIgnoreCase(DataEndpointConfiguration.Protocol.TCP.toString())) {
            int socketTimeout = AgentHolder.getInstance().getDataEndpointAgent("THRIFT").getAgentConfiguration().getSocketTimeoutMS();
            TSocket receiverTransport = new TSocket(hostName, port, socketTimeout);
            TBinaryProtocol tProtocol = new TBinaryProtocol(receiverTransport);
            ThriftEventTransmissionService.Client client = new ThriftEventTransmissionService.Client(tProtocol);
            try {
                ((TTransport)receiverTransport).open();
            }
            catch (TTransportException e) {
                throw new DataEndpointException("Error while making the connection." + e.getMessage(), e);
            }
            return client;
        }
        throw new DataEndpointException("Unsupported protocol :" + protocol + " used to authenticate the client, only " + DataEndpointConfiguration.Protocol.TCP.toString() + " is supported");
    }

    @Override
    public boolean validateClient(Object client) {
        ThriftEventTransmissionService.Client thriftClient = (ThriftEventTransmissionService.Client)client;
        return thriftClient.getOutputProtocol().getTransport().isOpen();
    }

    @Override
    public void terminateClient(Object client) {
        ThriftEventTransmissionService.Client thriftClient = (ThriftEventTransmissionService.Client)client;
        thriftClient.getOutputProtocol().getTransport().close();
    }
}

