/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.commons.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.carbon.databridge.commons.IndexDefinition;

public class IndexDefinitionConverterUtils {
    public static IndexDefinition getIndexDefinition(String indexDefinitionStr) {
        IndexDefinition indexDefinition = new IndexDefinition();
        indexDefinition.setIndexDataFromStore(indexDefinitionStr);
        return indexDefinition;
    }

    public static String getIndexDefinitionString(IndexDefinition indexDefinition) {
        if (indexDefinition != null) {
            String indexDefnStr = "";
            if (indexDefinition.getArbitraryIndexDefn() != null) {
                indexDefnStr = indexDefnStr + "[ARBITRARY_INDEX:=" + indexDefinition.getArbitraryIndexDefn() + "]" + ",\n";
            }
            if (indexDefinition.getCustomIndexDefn() != null) {
                indexDefnStr = indexDefnStr + "[CUSTOM_INDEX:=" + indexDefinition.getCustomIndexDefn() + "]" + ",\n";
            }
            if (indexDefinition.getFixedSearchDefn() != null) {
                indexDefnStr = indexDefnStr + "[FIXED_INDEX:=" + indexDefinition.getFixedSearchDefn() + "]" + ",\n";
            }
            if (indexDefinition.isIncrementalIndex()) {
                indexDefnStr = indexDefnStr + "[INCREMENTAL_INDEX:=" + indexDefinition.isIncrementalIndex() + "]" + ",\n";
            }
            if (indexDefinition.getSecondaryIndexDefn() != null) {
                indexDefnStr = indexDefnStr + "[SECONDARY_INDEX:=" + indexDefinition.getSecondaryIndexDefn() + "]" + ",\n";
            }
            if (!indexDefnStr.isEmpty()) {
                return indexDefnStr.substring(0, indexDefnStr.length() - 2);
            }
            return null;
        }
        return null;
    }

    public static String getSecondaryIndexString(String indexString) {
        return IndexDefinitionConverterUtils.getIndexString(indexString, "SECONDARY_INDEX");
    }

    public static String getIncrementalIndexString(String indexString) {
        return IndexDefinitionConverterUtils.getIndexString(indexString, "INCREMENTAL_INDEX");
    }

    public static String getFixedIndexString(String indexString) {
        return IndexDefinitionConverterUtils.getIndexString(indexString, "FIXED_INDEX");
    }

    public static String getCustomIndexString(String indexString) {
        return IndexDefinitionConverterUtils.getIndexString(indexString, "CUSTOM_INDEX");
    }

    public static String getArbitraryIndexString(String indexString) {
        return IndexDefinitionConverterUtils.getIndexString(indexString, "ARBITRARY_INDEX");
    }

    private static String getIndexString(String indexString, String indexName) {
        Pattern pattern = Pattern.compile("\\[(.*?)\\]");
        Matcher matcher = pattern.matcher(indexString);
        while (matcher.find()) {
            if (!matcher.group(1).trim().startsWith(indexName)) continue;
            String indexValue = matcher.group(1).replace(indexName, "");
            indexValue = indexValue.replace(":=", "");
            return indexValue.trim();
        }
        return "";
    }
}

