/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.PrepareString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerOrderingComparator
extends LdapComparator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(IntegerOrderingComparator.class);
    private static final long serialVersionUID = 1L;

    public IntegerOrderingComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String backendValue, String assertValue) {
        LOG.debug("comparing IntegerOrdering objects '{}' with '{}'", (Object)backendValue, (Object)assertValue);
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        try {
            backendValue = PrepareString.normalize(backendValue, PrepareString.StringType.NUMERIC_STRING);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(I18n.err("ERR_04224", backendValue));
        }
        try {
            assertValue = PrepareString.normalize(assertValue, PrepareString.StringType.NUMERIC_STRING);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(I18n.err("ERR_04224", assertValue));
        }
        BigInteger b1 = new BigInteger(backendValue);
        BigInteger b2 = new BigInteger(assertValue);
        return b1.compareTo(b2);
    }
}

