/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apacheds.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.directory.shared.ldap.schema.ldif.extractor.SchemaLdifExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CarbonSchemaLdifExtractor
implements SchemaLdifExtractor {
    private static final String SCHEMA_SUB_DIR = "schema";
    private static final Logger logger = LoggerFactory.getLogger(CarbonSchemaLdifExtractor.class);
    private boolean extracted;
    private File schemaDirectory;
    private File zipSchemaStore;

    public CarbonSchemaLdifExtractor(File outputDirectory, File zipSchemaStore) {
        this.zipSchemaStore = zipSchemaStore;
        this.schemaDirectory = new File(outputDirectory, SCHEMA_SUB_DIR);
        if (!outputDirectory.exists()) {
            logger.debug(String.format("Creating output directory: %s", outputDirectory));
            if (!outputDirectory.mkdir()) {
                logger.error(String.format("Failed to create outputDirectory: %s", outputDirectory));
            }
        } else {
            logger.debug("Output directory exists: no need to create.");
        }
        if (!this.schemaDirectory.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Schema directory '%s' does NOT exist: extracted state set to false.", this.schemaDirectory));
            }
            this.extracted = false;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Schema directory '%s' does exist: extracted state set to true.", this.schemaDirectory));
            }
            this.extracted = true;
        }
    }

    @Override
    public boolean isExtracted() {
        return this.extracted;
    }

    @Override
    public void extractOrCopy(boolean overwrite) throws IOException {
        if (this.schemaDirectory.exists() && overwrite) {
            FileUtils.deleteDirectory(this.schemaDirectory);
        }
        if (!this.schemaDirectory.exists() && !this.schemaDirectory.mkdir()) {
            throw new IOException("Unable to create schema directory " + this.schemaDirectory.getAbsolutePath());
        }
        if (!this.zipSchemaStore.exists()) {
            String msg = "Did not find LDAP schema files in " + this.zipSchemaStore.getAbsolutePath();
            logger.error(msg);
            throw new IOException(msg);
        }
        this.unzipSchemaFile();
        this.extracted = true;
    }

    protected void unzipSchemaFile() throws IOException {
        try {
            ZipEntry entry;
            FileInputStream schemaFileStream = new FileInputStream(this.zipSchemaStore);
            ZipInputStream zipFileStream = new ZipInputStream(new BufferedInputStream(schemaFileStream));
            String basePath = this.schemaDirectory.getAbsolutePath();
            while ((entry = zipFileStream.getNextEntry()) != null) {
                int size;
                if (entry.isDirectory()) {
                    File newDirectory = new File(basePath, entry.getName());
                    if (newDirectory.mkdir()) continue;
                    throw new IOException("Unable to create directory - " + newDirectory.getAbsolutePath());
                }
                byte[] buffer = new byte[2048];
                FileOutputStream extractedSchemaFile = new FileOutputStream(new File(basePath, entry.getName()));
                BufferedOutputStream extractingBufferedStream = new BufferedOutputStream(extractedSchemaFile, buffer.length);
                while ((size = zipFileStream.read(buffer, 0, buffer.length)) != -1) {
                    extractingBufferedStream.write(buffer, 0, size);
                }
                extractingBufferedStream.flush();
                extractingBufferedStream.close();
            }
            zipFileStream.close();
            schemaFileStream.close();
        }
        catch (IOException e) {
            String msg = "Unable to extract schema directory to location " + this.schemaDirectory.getAbsolutePath() + " from " + this.zipSchemaStore.getAbsolutePath();
            logger.error(msg, e);
            throw new IOException(msg, e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully extracted schema files to path " + this.schemaDirectory.getAbsolutePath() + " using schema zip file " + this.zipSchemaStore.getAbsolutePath());
        }
    }

    @Override
    public void extractOrCopy() throws IOException {
        this.extractOrCopy(false);
    }
}

