/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.GenericIndex;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSAnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DSAnnotationProcessor.class);

    private static DirectoryService createDS(CreateDS dsBuilder) throws Exception {
        LOG.debug("Starting DS {}...", (Object)dsBuilder.name());
        Class<?> factory = dsBuilder.factory();
        DirectoryServiceFactory dsf = (DirectoryServiceFactory)factory.newInstance();
        DirectoryService service = dsf.getDirectoryService();
        service.setAccessControlEnabled(dsBuilder.enableAccessControl());
        service.setAllowAnonymousAccess(dsBuilder.allowAnonAccess());
        service.getChangeLog().setEnabled(dsBuilder.enableChangeLog());
        List<Interceptor> interceptorList = service.getInterceptors();
        for (Class<?> interceptorClass : dsBuilder.additionalInterceptors()) {
            interceptorList.add((Interceptor)interceptorClass.newInstance());
        }
        service.setInterceptors(interceptorList);
        dsf.init(dsBuilder.name());
        for (CreatePartition createPartition : dsBuilder.partitions()) {
            CreateIndex[] indexes;
            Partition partition;
            if (createPartition.type() == Partition.class) {
                PartitionFactory partitionFactory = dsf.getPartitionFactory();
                partition = partitionFactory.createPartition(createPartition.name(), createPartition.suffix(), createPartition.cacheSize(), new File(service.getWorkingDirectory(), createPartition.name()));
                for (CreateIndex createIndex : indexes = createPartition.indexes()) {
                    partitionFactory.addIndex(partition, createIndex.attribute(), createIndex.cacheSize());
                }
            } else {
                partition = createPartition.type().newInstance();
                partition.setId(createPartition.name());
                partition.setSuffix(createPartition.suffix());
                if (partition instanceof BTreePartition) {
                    BTreePartition btreePartition = (BTreePartition)partition;
                    btreePartition.setCacheSize(createPartition.cacheSize());
                    btreePartition.setPartitionDir(new File(service.getWorkingDirectory(), createPartition.name()));
                    for (CreateIndex createIndex : indexes = createPartition.indexes()) {
                        GenericIndex index;
                        if (createIndex.type() == Index.class) {
                            index = new GenericIndex(createIndex.attribute(), createIndex.cacheSize());
                        } else {
                            index = createIndex.type().newInstance();
                            index.setAttributeId(createIndex.attribute());
                            index.setCacheSize(createIndex.cacheSize());
                        }
                        btreePartition.addIndexedAttributes(index);
                    }
                }
            }
            partition.setSchemaManager(service.getSchemaManager());
            service.addPartition(partition);
            ContextEntry contextEntry = createPartition.contextEntry();
            if (contextEntry == null) continue;
            DSAnnotationProcessor.injectEntries(service, contextEntry.entryLdif());
        }
        return service;
    }

    public static DirectoryService getDirectoryService(Description description) throws Exception {
        CreateDS dsBuilder = description.getAnnotation(CreateDS.class);
        if (dsBuilder != null) {
            return DSAnnotationProcessor.createDS(dsBuilder);
        }
        LOG.debug("No {} DS.", (Object)description.getDisplayName());
        return null;
    }

    public static DirectoryService getDirectoryService() throws Exception {
        Method method;
        Method[] methods;
        CreateDS dsBuilder = null;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = stackTrace[0].getMethodName().equals("dumpThreads") ? 3 : 2;
        Class<?> classCaller = Class.forName(stackTrace[index].getClassName());
        String methodCaller = stackTrace[index].getMethodName();
        Method[] arr$ = methods = classCaller.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || methodCaller.equals((method = arr$[i$]).getName()) && (dsBuilder = method.getAnnotation(CreateDS.class)) != null); ++i$) {
        }
        if (dsBuilder == null) {
            dsBuilder = classCaller.getAnnotation(CreateDS.class);
        }
        return DSAnnotationProcessor.createDS(dsBuilder);
    }

    private static void injectEntry(LdifEntry entry, DirectoryService service) throws Exception {
        if (entry.isChangeAdd()) {
            service.getAdminSession().add(new DefaultServerEntry(service.getSchemaManager(), entry.getEntry()));
        } else if (entry.isChangeModify()) {
            service.getAdminSession().modify(entry.getDn(), entry.getModificationItems());
        } else {
            String message = I18n.err(I18n.ERR_117, new Object[]{entry.getChangeType()});
            throw new NamingException(message);
        }
    }

    public static void injectLdifFiles(Class<?> clazz, DirectoryService service, String[] ldifFiles) throws Exception {
        if (ldifFiles != null && ldifFiles.length > 0) {
            for (String ldifFile : ldifFiles) {
                InputStream is = clazz.getClassLoader().getResourceAsStream(ldifFile);
                if (is == null) {
                    throw new FileNotFoundException("LDIF file '" + ldifFile + "' not found.");
                }
                try {
                    LdifReader ldifReader = new LdifReader(is);
                    for (LdifEntry entry : ldifReader) {
                        DSAnnotationProcessor.injectEntry(entry, service);
                    }
                    ldifReader.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_80, ldifFile, e.getLocalizedMessage()));
                }
            }
        }
    }

    public static void injectEntries(DirectoryService service, String ldif) throws Exception {
        LdifReader reader = new LdifReader();
        List<LdifEntry> entries = reader.parseLdif(ldif);
        for (LdifEntry entry : entries) {
            DSAnnotationProcessor.injectEntry(entry, service);
        }
        reader.close();
    }

    public static void applyLdifs(Description desc, DirectoryService service) throws Exception {
        ApplyLdifs applyLdifs;
        if (desc == null) {
            return;
        }
        ApplyLdifFiles applyLdifFiles = desc.getAnnotation(ApplyLdifFiles.class);
        if (applyLdifFiles != null) {
            LOG.debug("Applying {} to {}", (Object)applyLdifFiles.value(), (Object)desc.getDisplayName());
            DSAnnotationProcessor.injectLdifFiles(desc.getClass(), service, applyLdifFiles.value());
        }
        if ((applyLdifs = desc.getAnnotation(ApplyLdifs.class)) != null && applyLdifs.value() != null) {
            String[] ldifs = applyLdifs.value();
            String DN_START = "dn:";
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < ldifs.length) {
                String s;
                if (!(s = ldifs[i++].trim()).startsWith(DN_START)) continue;
                sb.append(s).append('\n');
                while (i < ldifs.length && !(s = ldifs[i++]).startsWith(DN_START)) {
                    sb.append(s).append('\n');
                }
                LOG.debug("Applying {} to {}", (Object)sb, (Object)desc.getDisplayName());
                DSAnnotationProcessor.injectEntries(service, sb.toString());
                sb.setLength(0);
                --i;
            }
        }
    }
}

