/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.crypto.encryption.Aes128CtsSha1Encryption;
import org.apache.directory.server.kerberos.shared.crypto.encryption.Aes256CtsSha1Encryption;
import org.apache.directory.server.kerberos.shared.crypto.encryption.ArcFourHmacMd5Encryption;
import org.apache.directory.server.kerberos.shared.crypto.encryption.Des3CbcSha1KdEncryption;
import org.apache.directory.server.kerberos.shared.crypto.encryption.DesCbcMd5Encryption;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.decoder.AuthenticatorDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.AuthorizationDataDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.Decoder;
import org.apache.directory.server.kerberos.shared.io.decoder.DecoderFactory;
import org.apache.directory.server.kerberos.shared.io.decoder.EncApRepPartDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.EncKdcRepPartDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.EncKrbPrivPartDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.EncTicketPartDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedTimestampDecoder;
import org.apache.directory.server.kerberos.shared.io.encoder.AuthenticatorEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncApRepPartEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncAsRepPartEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncKrbPrivPartEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncTgsRepPartEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncTicketPartEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncoderFactory;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedTimestampEncoder;
import org.apache.directory.server.kerberos.shared.messages.AuthenticationReply;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.TicketGrantReply;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncApRepPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncKdcRepPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedTimeStamp;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;

public class CipherTextHandler {
    private static final Map DEFAULT_ENCODERS;
    private static final Map DEFAULT_DECODERS;
    private static final Map DEFAULT_CIPHERS;

    public EncryptedData seal(EncryptionKey key, Encodable encodable, KeyUsage usage) throws KerberosException {
        try {
            return this.encrypt(key, this.encode(encodable), usage);
        }
        catch (IOException ioe) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)ioe);
        }
        catch (ClassCastException cce) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)cce);
        }
    }

    public Encodable unseal(Class hint, EncryptionKey key, EncryptedData data, KeyUsage usage) throws KerberosException {
        try {
            return this.decode(hint, this.decrypt(key, data, usage));
        }
        catch (IOException ioe) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)ioe);
        }
        catch (ClassCastException cce) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)cce);
        }
    }

    private EncryptedData encrypt(EncryptionKey key, byte[] plainText, KeyUsage usage) throws KerberosException {
        EncryptionEngine engine = this.getEngine(key);
        return engine.getEncryptedData(key, plainText, usage);
    }

    private byte[] decrypt(EncryptionKey key, EncryptedData data, KeyUsage usage) throws KerberosException {
        EncryptionEngine engine = this.getEngine(key);
        return engine.getDecryptedData(key, data, usage);
    }

    private byte[] encode(Encodable encodable) throws IOException {
        Class<?> encodableClass = encodable.getClass();
        Class clazz = (Class)DEFAULT_ENCODERS.get(encodableClass);
        if (clazz == null) {
            throw new IOException(I18n.err(I18n.ERR_597, encodableClass));
        }
        EncoderFactory factory = null;
        try {
            factory = (EncoderFactory)clazz.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new IOException(I18n.err(I18n.ERR_601, encodableClass));
        }
        catch (InstantiationException ie) {
            throw new IOException(I18n.err(I18n.ERR_599, encodableClass));
        }
        Encoder encoder = factory.getEncoder();
        return encoder.encode(encodable);
    }

    private Encodable decode(Class encodable, byte[] plainText) throws IOException {
        Class clazz = (Class)DEFAULT_DECODERS.get(encodable);
        if (clazz == null) {
            throw new IOException(I18n.err(I18n.ERR_600, encodable));
        }
        DecoderFactory factory = null;
        try {
            factory = (DecoderFactory)clazz.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new IOException(I18n.err(I18n.ERR_601, encodable));
        }
        catch (InstantiationException ie) {
            throw new IOException(I18n.err(I18n.ERR_602, encodable));
        }
        Decoder decoder = factory.getDecoder();
        return decoder.decode(plainText);
    }

    private EncryptionEngine getEngine(EncryptionKey key) throws KerberosException {
        EncryptionType encryptionType = key.getKeyType();
        Class clazz = (Class)DEFAULT_CIPHERS.get((Object)encryptionType);
        if (clazz == null) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP);
        }
        try {
            return (EncryptionEngine)clazz.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP, (Throwable)iae);
        }
        catch (InstantiationException ie) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP, (Throwable)ie);
        }
    }

    static {
        HashMap<Object, Class<ArcFourHmacMd5Encryption>> map = new HashMap<Object, Class<ArcFourHmacMd5Encryption>>();
        map.put(EncryptedTimeStamp.class, EncryptedTimestampEncoder.class);
        map.put(EncTicketPart.class, EncTicketPartEncoder.class);
        map.put(AuthenticationReply.class, EncAsRepPartEncoder.class);
        map.put(TicketGrantReply.class, EncTgsRepPartEncoder.class);
        map.put(EncKrbPrivPart.class, EncKrbPrivPartEncoder.class);
        map.put(EncApRepPart.class, EncApRepPartEncoder.class);
        map.put(Authenticator.class, AuthenticatorEncoder.class);
        DEFAULT_ENCODERS = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(EncTicketPart.class, EncTicketPartDecoder.class);
        map.put(Authenticator.class, AuthenticatorDecoder.class);
        map.put(EncryptedTimeStamp.class, EncryptedTimestampDecoder.class);
        map.put(AuthorizationData.class, AuthorizationDataDecoder.class);
        map.put(EncKrbPrivPart.class, EncKrbPrivPartDecoder.class);
        map.put(EncApRepPart.class, EncApRepPartDecoder.class);
        map.put(EncKdcRepPart.class, EncKdcRepPartDecoder.class);
        DEFAULT_DECODERS = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put((Object)EncryptionType.DES_CBC_MD5, (Class<ArcFourHmacMd5Encryption>)DesCbcMd5Encryption.class);
        map.put((Object)EncryptionType.DES3_CBC_SHA1_KD, (Class<ArcFourHmacMd5Encryption>)Des3CbcSha1KdEncryption.class);
        map.put((Object)EncryptionType.AES128_CTS_HMAC_SHA1_96, (Class<ArcFourHmacMd5Encryption>)Aes128CtsSha1Encryption.class);
        map.put((Object)EncryptionType.AES256_CTS_HMAC_SHA1_96, (Class<ArcFourHmacMd5Encryption>)Aes256CtsSha1Encryption.class);
        map.put((Object)EncryptionType.RC4_HMAC, ArcFourHmacMd5Encryption.class);
        DEFAULT_CIPHERS = Collections.unmodifiableMap(map);
    }
}

