/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.exception.LdapOperationException;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.apache.directory.shared.ldap.message.internal.InternalReferral;
import org.apache.directory.shared.ldap.message.internal.InternalResultResponseRequest;
import org.apache.directory.shared.ldap.message.internal.InternalSearchRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferralAwareRequestHandler<T extends InternalResultResponseRequest>
extends LdapRequestHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReferralAwareRequestHandler.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    @Override
    public final void handle(LdapSession session, T req) throws Exception {
        LOG.debug("Handling single reply request: {}", (Object)req);
        if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            LOG.debug("ManageDsaITControl detected.");
            this.handleIgnoringReferrals(session, req);
        } else {
            LOG.debug("ManageDsaITControl NOT detected.");
            switch (req.getType()) {
                case SEARCH_REQUEST: {
                    this.handleWithReferrals(session, ((InternalSearchRequest)req).getBase(), req);
                    break;
                }
                case EXTENDED_REQUEST: {
                    throw new IllegalStateException(I18n.err(I18n.ERR_684, new Object[0]));
                }
                default: {
                    throw new IllegalStateException(I18n.err(I18n.ERR_685, req));
                }
            }
        }
    }

    public static final boolean isEntryReferral(ClonedServerEntry entry) throws Exception {
        return entry.getOriginalEntry().contains("objectClass", "referral");
    }

    public static final ClonedServerEntry getFarthestReferralAncestor(LdapSession session, DN target) throws Exception {
        ClonedServerEntry farthestReferralAncestor = null;
        DN dn = (DN)target.clone();
        try {
            dn.remove(dn.size() - 1);
        }
        catch (LdapInvalidDnException e2) {
            // empty catch block
        }
        while (!dn.isEmpty()) {
            LOG.debug("Walking ancestors of {} to find referrals.", (Object)dn);
            try {
                ClonedServerEntry entry = session.getCoreSession().lookup(dn);
                if (ReferralAwareRequestHandler.isEntryReferral(entry)) {
                    farthestReferralAncestor = entry;
                }
                dn.remove(dn.size() - 1);
            }
            catch (LdapException e) {
                LOG.debug("Entry for {} not found.", (Object)dn);
                try {
                    dn.remove(dn.size() - 1);
                }
                catch (LdapInvalidDnException e1) {}
            }
        }
        return farthestReferralAncestor;
    }

    public InternalReferral getReferralOnAncestor(LdapSession session, DN reqTargetDn, T req, ClonedServerEntry referralAncestor) throws Exception {
        LOG.debug("Inside getReferralOnAncestor()");
        EntryAttribute refAttr = referralAncestor.getOriginalEntry().get("ref");
        ReferralImpl referral = new ReferralImpl();
        for (Value value : refAttr) {
            String ref = value.getString();
            LOG.debug("Calculating LdapURL for referrence value {}", (Object)ref);
            if (!ref.startsWith("ldap")) {
                referral.addLdapUrl(ref);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(ref.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                LOG.error(I18n.err(I18n.ERR_165, ref, referralAncestor));
            }
            DN urlDn = new DN(ldapUrl.getDn().getName());
            urlDn.normalize(session.getCoreSession().getDirectoryService().getSchemaManager().getNormalizerMapping());
            if (urlDn.getNormName().equals(referralAncestor.getDn().getNormName())) {
                StringBuilder buf = new StringBuilder();
                buf.append(ldapUrl.getScheme());
                buf.append(ldapUrl.getHost());
                if (ldapUrl.getPort() > 0) {
                    buf.append(":");
                    buf.append(ldapUrl.getPort());
                }
                referral.addLdapUrl(buf.toString());
                continue;
            }
            int diff = reqTargetDn.size() - referralAncestor.getDn().size();
            DN extra = new DN();
            DN reqUnnormalizedDn = new DN(reqTargetDn.getName());
            for (int jj = 0; jj < diff; ++jj) {
                extra.add(reqUnnormalizedDn.get(referralAncestor.getDn().size() + jj));
            }
            urlDn.addAll(extra);
            StringBuilder buf = new StringBuilder();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(LdapURL.urlEncode(urlDn.getName(), false));
            referral.addLdapUrl(buf.toString());
        }
        return referral;
    }

    public InternalReferral getReferralOnAncestorForSearch(LdapSession session, InternalSearchRequest req, ClonedServerEntry referralAncestor) throws Exception {
        LOG.debug("Inside getReferralOnAncestor()");
        EntryAttribute refAttr = referralAncestor.getOriginalEntry().get("ref");
        ReferralImpl referral = new ReferralImpl();
        for (Value value : refAttr) {
            String ref = value.getString();
            LOG.debug("Calculating LdapURL for referrence value {}", (Object)ref);
            if (!ref.startsWith("ldap")) {
                referral.addLdapUrl(ref);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(ref.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                LOG.error(I18n.err(I18n.ERR_165, ref, referralAncestor));
            }
            DN urlDn = new DN(ldapUrl.getDn().getName());
            urlDn.normalize(session.getCoreSession().getDirectoryService().getSchemaManager().getNormalizerMapping());
            if (urlDn.getNormName().equals(req.getBase().getNormName())) {
                ldapUrl.setForceScopeRendering(true);
                ldapUrl.setAttributes(req.getAttributes());
                ldapUrl.setScope(req.getScope().getScope());
                referral.addLdapUrl(ldapUrl.toString());
                continue;
            }
            int diff = req.getBase().size() - referralAncestor.getDn().size();
            DN extra = new DN();
            DN reqUnnormalizedDn = new DN(req.getBase().getName());
            for (int jj = 0; jj < diff; ++jj) {
                extra.add(reqUnnormalizedDn.get(referralAncestor.getDn().size() + jj));
            }
            ldapUrl.getDn().addAll(extra);
            ldapUrl.setForceScopeRendering(true);
            ldapUrl.setAttributes(req.getAttributes());
            ldapUrl.setScope(req.getScope().getScope());
            referral.addLdapUrl(ldapUrl.toString());
        }
        return referral;
    }

    @Override
    public void handleException(LdapSession session, InternalResultResponseRequest req, Exception e) {
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        ResultCodeEnum code = e instanceof LdapOperationException ? ((LdapOperationException)e).getResultCode() : ResultCodeEnum.getBestEstimate(e, req.getType());
        result.setResultCode(code);
        String msg = code.toString() + ": failed for " + req + ": " + e.getLocalizedMessage();
        LOG.debug(msg, e);
        if (IS_DEBUG) {
            msg = msg + ":\n" + ExceptionUtils.getStackTrace(e);
        }
        result.setErrorMessage(msg);
        if (e instanceof LdapOperationException) {
            boolean setMatchedDn;
            LdapOperationException ne = (LdapOperationException)e;
            boolean bl = setMatchedDn = code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            if (ne.getResolvedDn() != null && setMatchedDn) {
                result.setMatchedDn(ne.getResolvedDn());
            }
        }
        session.getIoSession().write(req.getResultResponse());
    }

    public abstract void handleIgnoringReferrals(LdapSession var1, T var2);

    public abstract void handleWithReferrals(LdapSession var1, DN var2, T var3) throws LdapException;
}

