/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;

public class ReplicaPeerConfiguration {
    private boolean refreshOnly;
    private long interval = 300000L;
    private static final long DEFAULT_INTERVAL = 300000L;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 10389;
    private static final int DEFAULT_SSL_PORT = 10636;
    private LdapURL producer;
    private DN principalDN;
    private String password;
    private String host;
    private int port;
    private DN baseDN;
    private boolean useSSL;

    public void setRefreshOnly(boolean refreshOnly) {
        this.refreshOnly = refreshOnly;
    }

    public boolean isRefreshOnly() {
        return this.refreshOnly;
    }

    public void setInterval(long interval) {
        this.interval = interval * 1000L;
    }

    public long getInterval() {
        return this.interval;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public void setPrincipalDN(String principalDN) throws LdapInvalidDnException {
        this.principalDN = new DN(principalDN);
    }

    public DN getPrincipalDN() {
        return this.principalDN;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setProducer(String producer) throws LdapURLEncodingException {
        this.producer = new LdapURL(producer);
        this.baseDN = this.producer.getDn();
        this.useSSL = "ldaps".equalsIgnoreCase(this.producer.getScheme());
        this.host = this.producer.getHost();
        if (StringTools.isEmpty(this.host)) {
            this.host = DEFAULT_HOST;
        }
        this.port = this.producer.getPort();
        if (this.port == -1) {
            this.port = this.useSSL ? 10636 : 10389;
        }
    }

    public LdapURL getProducer() {
        return this.producer;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

