/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.NotFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitNotFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitNotFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitNotFilterAction() {
        super("Initialize NOT filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            log.error(I18n.err("ERR_04009", new Object[0]));
            throw new DecoderException(I18n.err("ERR_04009", new Object[0]));
        }
        SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
        NotFilter notFilter = new NotFilter(ldapMessageContainer.getTlvId());
        searchRequest.addCurrentFilter(notFilter);
        if (IS_DEBUG) {
            log.debug("Initialize NOT filter");
        }
    }
}

