/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.util.ArrayEnumeration;
import org.apache.directory.shared.ldap.util.NestableRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesDictionary
extends Dictionary<String, String> {
    private final Preferences prefs;

    public PreferencesDictionary(Preferences prefs) {
        this.prefs = prefs;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    @Override
    public int size() {
        try {
            return this.prefs.keys().length;
        }
        catch (BackingStoreException e) {
            throw new NestableRuntimeException(I18n.err("ERR_04423", new Object[0]), e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.prefs.keys().length == 0;
        }
        catch (BackingStoreException e) {
            throw new NestableRuntimeException(I18n.err("ERR_04423", new Object[0]), e);
        }
    }

    @Override
    public Enumeration<String> elements() {
        try {
            return new ArrayEnumeration(this.prefs.keys()){

                public String nextElement() {
                    String key = (String)super.nextElement();
                    return PreferencesDictionary.this.prefs.get(key, null);
                }
            };
        }
        catch (BackingStoreException e) {
            throw new NestableRuntimeException(I18n.err("ERR_04423", new Object[0]), e);
        }
    }

    @Override
    public Enumeration<String> keys() {
        try {
            return new ArrayEnumeration(this.prefs.keys());
        }
        catch (BackingStoreException e) {
            throw new NestableRuntimeException(I18n.err("ERR_04423", new Object[0]), e);
        }
    }

    @Override
    public String get(Object key) {
        if (key instanceof String) {
            return this.prefs.get((String)key, null);
        }
        return this.prefs.get(key.toString(), null);
    }

    @Override
    public String remove(Object key) {
        String retval = this.get(key);
        if (key instanceof String) {
            this.prefs.remove((String)key);
        } else {
            this.prefs.remove(key.toString());
        }
        return retval;
    }

    @Override
    public String put(String key, String value) {
        String retval = this.get(key);
        this.prefs.put(key, value);
        return retval;
    }
}

