/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ldap.server.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Logger;
import org.wso2.carbon.apacheds.AdminGroupInfo;
import org.wso2.carbon.apacheds.AdminInfo;
import org.wso2.carbon.apacheds.KdcConfiguration;
import org.wso2.carbon.apacheds.LDAPConfiguration;
import org.wso2.carbon.apacheds.PartitionInfo;
import org.wso2.carbon.apacheds.PasswordAlgorithm;
import org.wso2.carbon.ldap.server.exception.DirectoryServerException;
import org.wso2.carbon.ldap.server.util.EmbeddingLDAPException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.utils.CarbonUtils;

public class LDAPConfigurationBuilder {
    private static String CARBON_KDC_PORT_CONFIG_SECTION = "Ports.EmbeddedLDAP.KDCServerPort";
    private static int DEFAULT_KDC_SERVER_PORT = 8000;
    private Logger logger = Logger.getLogger(LDAPConfigurationBuilder.class);
    private String userMgtXMLFilePath = null;
    private InputStream configurationFileStream;
    private String connectionPassword;
    private LDAPConfiguration ldapConfiguration;
    private PartitionInfo partitionConfigurations;
    private KdcConfiguration kdcConfigurations;
    private boolean kdcEnabled = false;

    public LDAPConfigurationBuilder(File file) throws FileNotFoundException {
        if (!file.exists()) {
            String msg = "File not found. - " + file.getAbsolutePath();
            this.logger.error(msg);
            throw new FileNotFoundException(msg);
        }
        try {
            this.configurationFileStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            String msg = "Could not open file - " + file.getAbsolutePath();
            this.logger.error(msg, e);
            throw new FileNotFoundException(msg);
        }
    }

    public void buildConfigurations() throws EmbeddingLDAPException {
        StAXOMBuilder builder;
        try {
            builder = new StAXOMBuilder(this.configurationFileStream);
        }
        catch (XMLStreamException e) {
            this.logger.error("Unable to build LDAP configurations.", e);
            throw new EmbeddingLDAPException("Unable to build LDAP configurations", e);
        }
        OMElement documentElement = builder.getDocumentElement();
        OMElement embeddedLdap = documentElement.getFirstChildWithName(new QName("EmbeddedLDAP"));
        this.buildLDAPConfigurations(embeddedLdap);
        if (this.ldapConfiguration.isEnable()) {
            this.buildPartitionConfigurations(documentElement);
            OMElement kdcConfigElement = documentElement.getFirstChildWithName(new QName("KDCServer"));
            this.buildKDCConfigurations(kdcConfigElement);
            this.partitionConfigurations.setKdcEnabled(this.kdcEnabled);
            if (this.kdcEnabled) {
                this.kdcConfigurations.setSystemAdminPassword(this.getConnectionPassword());
                this.kdcConfigurations.setPartitionInfo(this.getPartitionConfigurations());
            }
        }
    }

    public String getConnectionPassword() throws EmbeddingLDAPException {
        if (this.connectionPassword == null) {
            this.buildConfigurations();
        }
        return this.connectionPassword;
    }

    public LDAPConfiguration getLdapConfiguration() throws EmbeddingLDAPException {
        if (this.ldapConfiguration == null) {
            this.buildConfigurations();
        }
        return this.ldapConfiguration;
    }

    private void buildConnectionPassword(Map<String, String> propertyMap) throws EmbeddingLDAPException {
        this.connectionPassword = propertyMap.get("connectionPassword");
        if (this.connectionPassword == null) {
            throw new EmbeddingLDAPException("Connection password not specified in the configuration file.");
        }
    }

    private void buildLDAPConfigurations(OMElement embeddedLDAP) throws EmbeddingLDAPException {
        String enableInfo;
        Map<String, String> propertyMap = this.getChildPropertyElements(embeddedLDAP);
        this.ldapConfiguration = new LDAPConfiguration();
        this.buildConnectionPassword(propertyMap);
        String booleanString = propertyMap.get("accessControlEnabled");
        if (booleanString != null) {
            this.ldapConfiguration.setAccessControlOn(Boolean.parseBoolean(booleanString));
        }
        if ((booleanString = propertyMap.get("allowAnonymousAccess")) != null) {
            this.ldapConfiguration.setAllowAnonymousAccess(Boolean.parseBoolean(booleanString));
        }
        if ((booleanString = propertyMap.get("changedLogEnabled")) != null) {
            this.ldapConfiguration.setChangeLogEnabled(Boolean.parseBoolean(booleanString));
        }
        if ((booleanString = propertyMap.get("denormalizeOpAttrsEnabled")) != null) {
            this.ldapConfiguration.setDeNormalizedAttributesEnabled(Boolean.parseBoolean(booleanString));
        }
        if ("true".equals(enableInfo = propertyMap.get("enable"))) {
            this.ldapConfiguration.setEnable(true);
        } else {
            this.ldapConfiguration.setEnable(false);
        }
        this.ldapConfiguration.setInstanceId(propertyMap.get("instanceId"));
        this.ldapConfiguration.setLdapPort(this.getPort(propertyMap.get("port")));
        this.ldapConfiguration.setWorkingDirectory(propertyMap.get("workingDirectory"));
        this.ldapConfiguration.setAdminEntryObjectClass(propertyMap.get("AdminEntryObjectClass"));
        this.ldapConfiguration.setMaxPDUSize(this.getIntegerValue(propertyMap.get("maxPDUSize")));
        this.ldapConfiguration.setSaslHostName(propertyMap.get("saslHostName"));
        this.ldapConfiguration.setSaslPrincipalName(propertyMap.get("saslPrincipalName"));
    }

    private int getPort(String portParamValue) {
        int port = -1;
        if (portParamValue != null) {
            port = portParamValue.startsWith("${") ? CarbonUtils.getPortFromServerConfig((String)portParamValue) : Integer.parseInt(portParamValue);
        }
        return port;
    }

    private int getIntegerValue(String value) {
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    private Map<String, String> getChildPropertyElements(OMElement omElement) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator ite = omElement.getChildrenWithName(new QName("Property"));
        while (ite.hasNext()) {
            OMElement propElem = (OMElement)ite.next();
            String propName = propElem.getAttributeValue(new QName("name"));
            String propValue = propElem.getText();
            map.put(propName, propValue);
        }
        return map;
    }

    private void buildPartitionConfigurations(OMElement documentElement) {
        this.partitionConfigurations = new PartitionInfo();
        OMElement defaultPartition = documentElement.getFirstChildWithName(new QName("DefaultPartition"));
        Map<String, String> propertyMap = this.getChildPropertyElements(defaultPartition);
        this.partitionConfigurations.setPartitionId(propertyMap.get("id"));
        this.partitionConfigurations.setRealm(propertyMap.get("realm"));
        this.partitionConfigurations.setPartitionKdcPassword(propertyMap.get("kdcPassword"));
        this.partitionConfigurations.setLdapServerPrinciplePassword(propertyMap.get("ldapServerPrinciplePassword"));
        this.partitionConfigurations.setRootDN(this.getDomainNameForRealm(propertyMap.get("realm")));
        OMElement partitionAdmin = documentElement.getFirstChildWithName(new QName("PartitionAdmin"));
        propertyMap = this.getChildPropertyElements(partitionAdmin);
        AdminInfo defaultPartitionAdmin = this.buildPartitionAdminConfigurations(propertyMap);
        OMElement partitionAdminRole = documentElement.getFirstChildWithName(new QName("PartitionAdminGroup"));
        propertyMap = this.getChildPropertyElements(partitionAdminRole);
        AdminGroupInfo adminGroupInfo = this.buildPartitionAdminGroupConfigurations(propertyMap);
        defaultPartitionAdmin.setGroupInformation(adminGroupInfo);
        this.partitionConfigurations.setPartitionAdministrator(defaultPartitionAdmin);
    }

    private AdminInfo buildPartitionAdminConfigurations(Map<String, String> propertyMap) {
        AdminInfo adminInfo = new AdminInfo();
        adminInfo.setAdminUserName(propertyMap.get("uid"));
        adminInfo.setAdminCommonName(propertyMap.get("firstName"));
        adminInfo.setAdminLastName(propertyMap.get("lastName"));
        adminInfo.setAdminEmail(propertyMap.get("email"));
        adminInfo.setAdminPassword(propertyMap.get("password"));
        adminInfo.setPasswordAlgorithm(PasswordAlgorithm.valueOf(propertyMap.get("passwordType")));
        adminInfo.addObjectClass(this.ldapConfiguration.getAdminEntryObjectClass());
        adminInfo.setUsernameAttribute("uid");
        return adminInfo;
    }

    private AdminGroupInfo buildPartitionAdminGroupConfigurations(Map<String, String> propertyMap) {
        AdminGroupInfo adminGroupInfo = new AdminGroupInfo();
        adminGroupInfo.setAdminRoleName(propertyMap.get("adminRoleName"));
        adminGroupInfo.setGroupNameAttribute(propertyMap.get("groupNameAttribute"));
        adminGroupInfo.setMemberNameAttribute(propertyMap.get("memberNameAttribute"));
        return adminGroupInfo;
    }

    private String getDomainNameForRealm(String realm) {
        if (realm == null) {
            return null;
        }
        String[] components = realm.split("\\.");
        if (components.length == 0) {
            return "dc=" + realm;
        }
        StringBuilder domainName = new StringBuilder();
        for (int i = 0; i < components.length; ++i) {
            domainName.append("dc=");
            domainName.append(components[i]);
            if (i == components.length - 1) continue;
            domainName.append(",");
        }
        return domainName.toString();
    }

    public PartitionInfo getPartitionConfigurations() throws EmbeddingLDAPException {
        if (this.partitionConfigurations == null) {
            this.buildConfigurations();
        }
        return this.partitionConfigurations;
    }

    public KdcConfiguration getKdcConfigurations() throws EmbeddingLDAPException {
        if (this.kdcConfigurations == null) {
            this.buildConfigurations();
        }
        return this.kdcConfigurations;
    }

    public boolean isKdcEnabled() {
        return this.kdcEnabled;
    }

    private void buildKDCConfigurations(OMElement kdcConfigElement) throws EmbeddingLDAPException {
        Map<String, String> propertyMap = this.getChildPropertyElements(kdcConfigElement);
        String booleanString = propertyMap.get("enabled");
        if (booleanString != null) {
            this.kdcEnabled = Boolean.parseBoolean(booleanString);
            if (!this.kdcEnabled) {
                this.logger.info("KDC server is disabled.");
                return;
            }
        } else {
            this.logger.info("KDC server is disabled.");
            return;
        }
        this.kdcConfigurations = new KdcConfiguration();
        this.kdcConfigurations.setKdcName(propertyMap.get("name"));
        try {
            this.kdcConfigurations.setKdcCommunicationProtocol(propertyMap.get("protocol"));
        }
        catch (DirectoryServerException e) {
            String errorMessage = "Can not read/set protocol parameter in KDCConfig.";
            this.logger.error(errorMessage, e);
            throw new EmbeddingLDAPException(errorMessage, e);
        }
        this.kdcConfigurations.setKdcHostAddress(propertyMap.get("host"));
        int port = this.getPort(propertyMap.get("port"));
        if (port == -1) {
            this.logger.warn("KDC port defined in carbon.xml's " + CARBON_KDC_PORT_CONFIG_SECTION + " config section or embedded-ldap.xml is invalid. " + "Setting KDC server port to default - " + DEFAULT_KDC_SERVER_PORT);
            port = DEFAULT_KDC_SERVER_PORT;
        }
        this.kdcConfigurations.setKdcCommunicationPort(port);
        this.kdcConfigurations.setMaxTicketLifeTime(this.getIntegerValue(propertyMap.get("maximumTicketLifeTime")));
        this.kdcConfigurations.setMaxRenewableLifeTime(this.getIntegerValue(propertyMap.get("maximumRenewableLifeTime")));
        booleanString = propertyMap.get("preAuthenticationTimeStampEnabled");
        if (booleanString != null) {
            boolean preAuthenticationTSEnabled = Boolean.parseBoolean(booleanString);
            this.kdcConfigurations.setPreAuthenticateTimeStampRequired(preAuthenticationTSEnabled);
        }
    }

    public boolean isEmbeddedLDAPEnabled() {
        return this.ldapConfiguration.isEnable();
    }

    protected RealmConfiguration getUserManagementXMLElement() {
        String carbonHome;
        String REALM_CONFIG_FILE = "user-mgt.xml";
        StAXOMBuilder builder = null;
        FileInputStream inStream = null;
        OMElement realmElement = null;
        RealmConfiguration config = null;
        if (this.userMgtXMLFilePath == null && (carbonHome = CarbonUtils.getCarbonHome()) != null) {
            this.userMgtXMLFilePath = CarbonUtils.getCarbonConfigDirPath();
        }
        try {
            File userMgtXMLFile = new File(this.userMgtXMLFilePath, REALM_CONFIG_FILE);
            if (userMgtXMLFile.exists()) {
                inStream = new FileInputStream(userMgtXMLFile);
            }
            builder = new StAXOMBuilder(inStream);
            OMElement documentElement = builder.getDocumentElement();
            realmElement = documentElement.getFirstChildWithName(new QName("Realm"));
            RealmConfigXMLProcessor rmProcessor = new RealmConfigXMLProcessor();
            config = rmProcessor.buildRealmConfiguration(realmElement);
        }
        catch (FileNotFoundException | XMLStreamException e) {
            String errorMsg = "User-mgt.xml is not found. Hence admin properties will be read from embedded-ldap.xml";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(errorMsg, e);
            }
        }
        catch (UserStoreException e) {
            this.logger.error("Error occured while reading user-mgt.xml", e);
        }
        return config;
    }

    public void setUserMgtXMLFilePath(String filePath) {
        this.userMgtXMLFilePath = filePath;
    }
}

