/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config.model;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.config.model.ScheduledReporterConfig;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.reporter.ReporterBuilder;
import org.wso2.carbon.metrics.core.reporter.impl.CsvReporter;

public class CsvReporterConfig
extends ScheduledReporterConfig
implements ReporterBuilder<CsvReporter> {
    private static final Logger logger = LoggerFactory.getLogger(CsvReporterConfig.class);
    private String location;

    public CsvReporterConfig() {
        super("CSV");
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public Optional<CsvReporter> build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterBuildException {
        if (!this.isEnabled()) {
            return Optional.empty();
        }
        if (this.location == null || this.location.trim().isEmpty()) {
            throw new ReporterBuildException("CSV Reporting location is not specified");
        }
        File csvLocation = new File(this.location);
        if (!csvLocation.exists() && !csvLocation.mkdir()) {
            throw new ReporterBuildException("Could not create the CSV Reporting Location: " + this.location);
        }
        if (!csvLocation.isDirectory()) {
            throw new ReporterBuildException("CSV Reporting location is not a directory");
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating CSV reporter for Metrics with location '%s' and %d seconds polling period", this.location, this.getPollingPeriod()));
        }
        return Optional.of(new CsvReporter(this.getName(), metricRegistry, this.getFilter(metricFilter), csvLocation, this.getPollingPeriod()));
    }
}

