/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import java.nio.charset.Charset;
import java.util.HashMap;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.messaging.ServerConnectorErrorHandler;

@Component(name="http.server.connector.error.handler", immediate=true, service={ServerConnectorErrorHandler.class})
public class HTTPServerConnectorErrorHandler
implements ServerConnectorErrorHandler {
    @Override
    public void handleError(Exception exception, CarbonMessage carbonMessage, CarbonCallback carbonCallback) throws Exception {
        carbonCallback.done(this.createErrorMessage(exception.getMessage(), 500));
    }

    @Override
    public String getProtocol() {
        return "http";
    }

    private CarbonMessage createErrorMessage(String payload, int statusCode) {
        DefaultCarbonMessage response = new DefaultCarbonMessage();
        response.setStringMessageBody(payload);
        byte[] errorMessageBytes = payload.getBytes(Charset.defaultCharset());
        HashMap<String, String> transportHeaders = new HashMap<String, String>();
        transportHeaders.put("Connection", "keep-alive");
        transportHeaders.put("Content-Type", "text/plain");
        transportHeaders.put("Content-Length", String.valueOf(errorMessageBytes.length));
        response.setHeaders(transportHeaders);
        response.setProperty("HTTP_STATUS_CODE", statusCode);
        response.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        return response;
    }
}

