/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.BinaryCarbonMessage;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ControlCarbonMessage;
import org.wso2.carbon.messaging.StatusCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.exception.UnknownWebSocketFrameTypeException;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.internal.websocket.WebSocketSessionImpl;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class WebSocketSourceHandler
extends SourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSourceHandler.class);
    private final String uri;
    private CarbonMessage cMsg;
    private final String channelId;
    private final boolean isSecured;
    private final WebSocketSessionImpl session;

    public WebSocketSourceHandler(String channelId, ConnectionManager connectionManager, ListenerConfiguration listenerConfiguration, String uri, boolean isSecured, ChannelHandlerContext ctx) throws Exception {
        super(connectionManager, listenerConfiguration);
        this.uri = uri;
        this.channelId = channelId;
        this.isSecured = isSecured;
        this.session = new WebSocketSessionImpl(ctx, isSecured, uri, channelId);
        this.sendOnOpenMessage(ctx, isSecured, uri);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws UnknownWebSocketFrameTypeException {
        this.cMsg = null;
        if (!(msg instanceof WebSocketFrame)) {
            logger.error("Expecting WebSocketFrame. Unknown type.");
            throw new UnknownWebSocketFrameTypeException("Expecting WebSocketFrame. Unknown type.");
        }
        if (msg instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)msg;
            String text = textWebSocketFrame.text();
            this.cMsg = new TextCarbonMessage(text);
            this.setupCarbonMessage(ctx);
        } else if (msg instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)msg;
            boolean finalFragment = binaryWebSocketFrame.isFinalFragment();
            ByteBuf byteBuf = binaryWebSocketFrame.content();
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            this.cMsg = new BinaryCarbonMessage(byteBuffer, finalFragment);
            this.setupCarbonMessage(ctx);
        } else if (msg instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)msg;
            String reasonText = closeWebSocketFrame.reasonText();
            int statusCode = closeWebSocketFrame.statusCode();
            ctx.channel().close();
            this.session.setIsOpen(false);
            this.cMsg = new StatusCarbonMessage("STATUS_CLOSE", statusCode, reasonText);
            this.setupCarbonMessage(ctx);
            this.cMsg.setProperty("WEBSOCKET_SESSION", this.session);
        } else if (msg instanceof PongWebSocketFrame) {
            PongWebSocketFrame pongWebSocketFrame = (PongWebSocketFrame)msg;
            boolean finalFragment = pongWebSocketFrame.isFinalFragment();
            ByteBuf byteBuf = pongWebSocketFrame.content();
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            this.cMsg = new ControlCarbonMessage(byteBuffer, finalFragment);
            this.setupCarbonMessage(ctx);
        }
        this.publishToMessageProcessor(this.cMsg);
    }

    @Override
    protected void publishToMessageProcessor(CarbonMessage cMsg) {
        CarbonMessageProcessor carbonMessageProcessor;
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(cMsg);
        }
        if ((carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor()) != null) {
            try {
                carbonMessageProcessor.receive(cMsg, null);
            }
            catch (Exception e) {
                logger.error("Error while submitting CarbonMessage to CarbonMessageProcessor.", e);
                this.ctx.channel().close();
            }
        } else {
            logger.error("Cannot find registered MessageProcessor to forward the message.");
            this.ctx.channel().close();
        }
    }

    private void sendOnOpenMessage(ChannelHandlerContext ctx, boolean isSecured, String uri) throws URISyntaxException {
        this.cMsg = new StatusCarbonMessage("STATUS_OPEN", 0, null);
        this.setupCarbonMessage(ctx);
        this.cMsg.setProperty("Connection", "Upgrade");
        this.cMsg.setProperty("Upgrade", "websocket");
        this.publishToMessageProcessor(this.cMsg);
    }

    private void setupCarbonMessage(ChannelHandlerContext ctx) {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(this.cMsg);
        }
        this.cMsg.setProperty("PORT", ((InetSocketAddress)ctx.channel().remoteAddress()).getPort());
        this.cMsg.setProperty("HOST", ((InetSocketAddress)ctx.channel().remoteAddress()).getHostName());
        this.cMsg.setProperty("TO", this.uri);
        this.cMsg.setProperty("LISTENER_PORT", ((InetSocketAddress)ctx.channel().localAddress()).getPort());
        this.cMsg.setProperty("IS_SECURED_CONNECTION", this.isSecured);
        this.cMsg.setProperty("LOCAL_ADDRESS", ctx.channel().localAddress());
        this.cMsg.setProperty("LOCAL_NAME", ((InetSocketAddress)ctx.channel().localAddress()).getHostName());
        this.cMsg.setProperty("REMOTE_ADDRESS", ctx.channel().remoteAddress());
        this.cMsg.setProperty("REMOTE_HOST", ((InetSocketAddress)ctx.channel().remoteAddress()).getHostName());
        this.cMsg.setProperty("REMOTE_PORT", ((InetSocketAddress)ctx.channel().remoteAddress()).getPort());
        this.cMsg.setProperty("CHANNEL_ID", ((SourceHandler)ctx.handler()).getListenerConfiguration().getId());
        this.cMsg.setProperty("PROTOCOL", "ws");
        this.cMsg.setProperty("WEBSOCKET_SESSION", this.session);
    }
}

