/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.transports.TransportManager;
import org.wso2.carbon.messaging.ServerConnector;
import org.wso2.carbon.messaging.ServerConnectorProvider;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.listener.HTTPServerConnector;
import org.wso2.carbon.transport.http.netty.listener.HTTPServerConnectorProvider;
import org.wso2.carbon.transport.http.netty.listener.HTTPTransportListener;
import org.wso2.carbon.transport.http.netty.listener.ServerConnectorController;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.SessionManager;
import org.wso2.msf4j.interceptor.RequestInterceptor;
import org.wso2.msf4j.interceptor.ResponseInterceptor;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MSF4JMessageProcessor;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.internal.websocket.EndpointsRegistryImpl;
import org.wso2.msf4j.util.RuntimeAnnotations;

public class MicroservicesRunner {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesRunner.class);
    private TransportManager transportManager = new TransportManager();
    protected List<ServerConnector> serverConnectors = new ArrayList<ServerConnector>();
    private long startTime = System.currentTimeMillis();
    private boolean isStarted;
    private MicroservicesRegistryImpl msRegistry = new MicroservicesRegistryImpl();
    private EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();

    public MicroservicesRunner(int ... ports) {
        this.configureTransport(ports);
    }

    public MicroservicesRunner() {
        this.configureTransport();
    }

    public MicroservicesRunner deploy(Object ... microservice) {
        this.checkState();
        this.msRegistry.addService(microservice);
        return this;
    }

    public MicroservicesRunner deploy(String basePath, Object microservice) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("value", basePath);
        RuntimeAnnotations.putAnnotation(microservice.getClass(), Path.class, valuesMap);
        this.msRegistry.addService(basePath, microservice);
        return this;
    }

    public MicroservicesRunner deployWebSocketEndpoint(Object webSocketEndpoint) {
        this.endpointsRegistry.addEndpoint(webSocketEndpoint);
        return this;
    }

    public MicroservicesRunner setSessionManager(SessionManager sessionManager) {
        this.msRegistry.setSessionManager(sessionManager);
        return this;
    }

    public MicroservicesRunner addGlobalRequestInterceptor(RequestInterceptor ... requestInterceptor) {
        this.checkState();
        this.msRegistry.addGlobalRequestInterceptor(requestInterceptor);
        return this;
    }

    public MicroservicesRunner addGlobalResponseInterceptor(ResponseInterceptor ... responseInterceptor) {
        this.checkState();
        this.msRegistry.addGlobalResponseInterceptor(responseInterceptor);
        return this;
    }

    public MicroservicesRunner addInterceptor(Interceptor ... interceptor) {
        this.checkState();
        this.msRegistry.addGlobalRequestInterceptor(interceptor);
        this.msRegistry.addGlobalResponseInterceptor(interceptor);
        return this;
    }

    public MicroservicesRunner addExceptionMapper(ExceptionMapper ... exceptionMapper) {
        this.checkState();
        this.msRegistry.addExceptionMapper(exceptionMapper);
        return this;
    }

    protected void configureTransport(int ... ports) {
        HashSet<TransportProperty> transportProperties = new HashSet<TransportProperty>();
        TransportProperty transportProperty = new TransportProperty();
        int bossGroupSize = Runtime.getRuntime().availableProcessors();
        transportProperty.setName("server.bootstrap.boss.group.size");
        transportProperty.setValue(bossGroupSize);
        TransportProperty workerGroup = new TransportProperty();
        int workerGroupSize = Runtime.getRuntime().availableProcessors() * 2;
        workerGroup.setName("server.bootstrap.worker.group.size");
        workerGroup.setValue(workerGroupSize);
        transportProperties.add(transportProperty);
        transportProperties.add(workerGroup);
        TransportsConfiguration transportsConfiguration = new TransportsConfiguration();
        ServerConnectorController serverConnectorController = new ServerConnectorController(transportsConfiguration);
        serverConnectorController.start();
        HTTPServerConnectorProvider httpServerConnectorProvider = new HTTPServerConnectorProvider();
        transportsConfiguration.setTransportProperties(transportProperties);
        HashSet<ListenerConfiguration> listenerConfigurations = new HashSet<ListenerConfiguration>();
        for (int port : ports) {
            ListenerConfiguration listenerConfiguration = new ListenerConfiguration("netty-" + port, "0.0.0.0", port);
            DataHolder.getInstance().getMicroservicesRegistries().put(listenerConfiguration.getId(), this.msRegistry);
            listenerConfigurations.add(listenerConfiguration);
        }
        transportsConfiguration.setListenerConfigurations(listenerConfigurations);
        this.serverConnectors.addAll(httpServerConnectorProvider.initializeConnectors(transportsConfiguration));
        this.serverConnectors.forEach(serverConnector -> serverConnector.setMessageProcessor(new MSF4JMessageProcessor()));
    }

    protected void configureTransport() {
        ServiceLoader<ServerConnectorProvider> serverConnectorProviderLoader = ServiceLoader.load(ServerConnectorProvider.class);
        serverConnectorProviderLoader.forEach(serverConnectorProvider -> {
            if (serverConnectorProvider instanceof HTTPServerConnectorProvider) {
                this.serverConnectors.addAll(serverConnectorProvider.initializeConnectors());
                this.serverConnectors.forEach(serverConnector -> {
                    serverConnector.setMessageProcessor(new MSF4JMessageProcessor());
                    DataHolder.getInstance().getMicroservicesRegistries().put(serverConnector.getId(), this.msRegistry);
                });
            }
        });
    }

    protected void registerTransport(HTTPTransportListener listener) {
        this.transportManager.registerTransport(listener);
    }

    private void checkState() {
        if (this.isStarted) {
            throw new IllegalStateException("Microservices runner already started");
        }
    }

    public void start() {
        this.msRegistry.getSessionManager().init();
        this.handleServiceLifecycleMethods();
        this.serverConnectors.forEach(serverConnector -> {
            try {
                serverConnector.start();
                this.isStarted = true;
                log.info("Microservices server started in " + (System.currentTimeMillis() - this.startTime) + "ms");
            }
            catch (ServerConnectorException e) {
                log.error("Error while starting the Microservices server. " + e.getMessage(), e);
                throw new RuntimeException("Error while starting the Microservices server.", e);
            }
        });
    }

    public void stop() {
        this.serverConnectors.forEach(serverConnector -> ((HTTPServerConnector)serverConnector).stop());
        log.info("Microservices server stopped");
    }

    public MicroservicesRegistryImpl getMsRegistry() {
        return this.msRegistry;
    }

    protected void handleServiceLifecycleMethods() {
        this.msRegistry.initServices();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MicroservicesRunner.this.msRegistry.preDestroyServices();
            }
        });
    }
}

