/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.messaging.Header;
import org.wso2.carbon.messaging.Headers;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Session;
import org.wso2.msf4j.internal.entitywriter.EntityWriter;
import org.wso2.msf4j.internal.entitywriter.EntityWriterRegistry;

public class Response {
    private static final String COMMA_SEPARATOR = ", ";
    private static final int NULL_STATUS_CODE = -1;
    public static final int NO_CHUNK = 0;
    public static final int DEFAULT_CHUNK_SIZE = -1;
    private final CarbonMessage carbonMessage = new DefaultCarbonMessage();
    private final CarbonCallback carbonCallback;
    private int statusCode = -1;
    private String mediaType = null;
    private Object entity;
    private int chunkSize = 0;
    private Request request;
    private javax.ws.rs.core.Response jaxrsResponse;

    public Response(CarbonCallback carbonCallback) {
        this.carbonCallback = carbonCallback;
    }

    public Response(CarbonCallback carbonCallback, Request request) {
        this(carbonCallback);
        this.request = request;
    }

    public boolean isEomAdded() {
        return this.carbonMessage.isEndOfMsgAdded();
    }

    public boolean isEmpty() {
        return this.carbonMessage.isEmpty();
    }

    public ByteBuffer getMessageBody() {
        return this.carbonMessage.getMessageBody();
    }

    public List<ByteBuffer> getFullMessageBody() {
        return this.carbonMessage.getFullMessageBody();
    }

    public Headers getHeaders() {
        return this.carbonMessage.getHeaders();
    }

    public String getHeader(String key) {
        return this.carbonMessage.getHeader(key);
    }

    public Response setHeader(String key, String value) {
        this.carbonMessage.setHeader(key, value);
        return this;
    }

    public void setHeaders(Map<String, String> headerMap) {
        this.carbonMessage.setHeaders(headerMap);
    }

    public Object getProperty(String key) {
        return this.carbonMessage.getProperty(key);
    }

    public Map<String, Object> getProperties() {
        return this.carbonMessage.getProperties();
    }

    public void setProperty(String key, Object value) {
        this.carbonMessage.setProperty(key, value);
    }

    public void removeHeader(String key) {
        this.carbonMessage.removeHeader(key);
    }

    public void removeProperty(String key) {
        this.carbonMessage.removeProperty(key);
    }

    public CarbonMessage getCarbonMessage() {
        return this.carbonMessage;
    }

    public Response setStatus(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public int getStatusCode() {
        if (this.statusCode != -1) {
            return this.statusCode;
        }
        if (this.entity != null) {
            return Response.Status.OK.getStatusCode();
        }
        return Response.Status.NO_CONTENT.getStatusCode();
    }

    public Response setMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public Response setEntity(Object entity) {
        if (!this.carbonMessage.isEmpty()) {
            throw new IllegalStateException("CarbonMessage should not contain a message body");
        }
        if (entity instanceof javax.ws.rs.core.Response) {
            javax.ws.rs.core.Response response;
            this.jaxrsResponse = response = (javax.ws.rs.core.Response)entity;
            this.entity = response.getEntity();
            this.setStatus(response.getStatus());
            if (response.getMediaType() != null) {
                this.setMediaType(response.getMediaType().toString());
            }
        } else {
            this.entity = entity;
        }
        return this;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void send() {
        Session session;
        this.carbonMessage.setProperty("HTTP_STATUS_CODE", this.getStatusCode());
        ArrayList<Header> cookiesHeader = new ArrayList<Header>();
        if (this.jaxrsResponse != null) {
            MultivaluedMap<String, String> multivaluedMap = this.jaxrsResponse.getStringHeaders();
            if (multivaluedMap != null) {
                multivaluedMap.forEach((key, strings) -> this.setHeader((String)key, String.join((CharSequence)COMMA_SEPARATOR, strings)));
            }
            Map<String, NewCookie> cookies = this.jaxrsResponse.getCookies();
            cookies.forEach((name, cookie) -> cookiesHeader.add(new Header("Set-Cookie", cookie.getName() + "=" + cookie.getValue())));
        }
        if ((session = this.request.getSessionInternal()) != null && session.isValid() && session.isNew()) {
            cookiesHeader.add(new Header("Set-Cookie", "JSESSIONID=" + session.getId()));
        }
        this.carbonMessage.getHeaders().set(cookiesHeader);
        this.processEntity();
    }

    private void processEntity() {
        if (this.entity != null) {
            EntityWriter entityWriter = EntityWriterRegistry.getEntityWriter(this.entity.getClass());
            entityWriter.writeData(this.carbonMessage, this.entity, this.mediaType, this.chunkSize, this.carbonCallback);
        } else {
            this.carbonMessage.addMessageBody(ByteBuffer.allocate(0));
            this.carbonMessage.setEndOfMsgAdded(true);
            this.carbonCallback.done(this.carbonMessage);
        }
    }
}

