/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.deployer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.internal.deployer.MicroserviceDeploymentException;

public class MicroserviceDeploymentUtils {
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceDeploymentUtils.class);
    private static final String MICROSERVICES_MANIFEST_KEY = "Microservices";

    public static List<Object> getRourceInstances(final File artifactFile) throws MicroserviceDeploymentException {
        ArrayList<Object> resourceInstances;
        block2: {
            String jarPath = artifactFile.getAbsolutePath();
            final String[] serviceClassNames = MicroserviceDeploymentUtils.readManifestEntry(jarPath);
            resourceInstances = new ArrayList<Object>();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws MicroserviceDeploymentException {
                        try {
                            URLClassLoader classLoader = new URLClassLoader(new URL[]{artifactFile.toURI().toURL()}, this.getClass().getClassLoader());
                            for (String className : serviceClassNames) {
                                try {
                                    Class<?> classToLoad = classLoader.loadClass(className);
                                    resourceInstances.add(classToLoad.newInstance());
                                }
                                catch (ClassNotFoundException e) {
                                    throw new MicroserviceDeploymentException("Class: " + className + " not found", e);
                                }
                                catch (InstantiationException e) {
                                    throw new MicroserviceDeploymentException("Failed to initialize class: " + className, e);
                                }
                                catch (IllegalAccessException e) {
                                    throw new MicroserviceDeploymentException("Failed to access class: " + className, e);
                                }
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new MicroserviceDeploymentException("Path to jar is invalid", e);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                if (!(e1 instanceof MicroserviceDeploymentException)) break block2;
                throw (MicroserviceDeploymentException)e1;
            }
        }
        return resourceInstances;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] readManifestEntry(String jarPath) throws MicroserviceDeploymentException {
        try (JarFile jarFile = new JarFile(jarPath);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                throw new MicroserviceDeploymentException("Error retrieving manifest: " + jarPath);
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String serviceEntry = mainAttributes.getValue(MICROSERVICES_MANIFEST_KEY);
            if (serviceEntry == null) {
                throw new MicroserviceDeploymentException("Manifest entry 'microservices' not found: " + jarPath);
            }
            String[] stringArray = serviceEntry.split("\\s*,\\s*");
            return stringArray;
        }
        catch (IOException e) {
            throw new MicroserviceDeploymentException("Error retrieving manifest: " + jarPath, e);
        }
    }
}

