/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.bind;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.bind.LdapAuthentication;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslCredentials
extends LdapAuthentication {
    private static Logger log = LoggerFactory.getLogger(SimpleAuthentication.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private String mechanism;
    private byte[] mechanismBytes;
    private byte[] credentials;
    private int mechanismLength;
    private int credentialsLength;

    public byte[] getCredentials() {
        if (this.credentials == null) {
            return null;
        }
        byte[] copy = new byte[this.credentials.length];
        System.arraycopy(this.credentials, 0, copy, 0, this.credentials.length);
        return copy;
    }

    public void setCredentials(byte[] credentials) {
        if (credentials != null) {
            this.credentials = new byte[credentials.length];
            System.arraycopy(credentials, 0, this.credentials, 0, credentials.length);
        } else {
            this.credentials = null;
        }
    }

    public String getMechanism() {
        return this.mechanism == null ? null : this.mechanism;
    }

    public void setMechanism(String mechanism) {
        this.mechanism = mechanism;
    }

    public int computeLength() {
        this.mechanismBytes = StringTools.getBytesUtf8(this.mechanism);
        this.mechanismLength = 1 + TLV.getNbBytes(this.mechanismBytes.length) + this.mechanismBytes.length;
        this.credentialsLength = 0;
        if (this.credentials != null) {
            this.credentialsLength = 1 + TLV.getNbBytes(this.credentials.length) + this.credentials.length;
        }
        int saslLength = 1 + TLV.getNbBytes(this.mechanismLength + this.credentialsLength) + this.mechanismLength + this.credentialsLength;
        if (IS_DEBUG) {
            log.debug("SASL Authentication length : {}", (Object)saslLength);
        }
        return saslLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            log.error(I18n.err("ERR_04023", new Object[0]));
            throw new EncoderException(I18n.err("ERR_04023", new Object[0]));
        }
        try {
            buffer.put((byte)-93);
            buffer.put(TLV.getBytes(this.mechanismLength + this.credentialsLength));
            Value.encode(buffer, this.mechanism);
            if (this.credentials != null) {
                Value.encode(buffer, this.credentials);
            }
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err("ERR_04005", new Object[0]));
            throw new EncoderException(I18n.err("ERR_04005", new Object[0]));
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("        Sasl credentials\n");
        sb.append("            Mechanism :'").append(this.mechanism).append('\'');
        if (this.credentials != null) {
            sb.append("\n            Credentials :'").append(StringTools.dumpBytes(this.credentials)).append('\'');
        }
        return sb.toString();
    }
}

