/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.message.internal.InternalCompareRequest;
import org.apache.directory.shared.ldap.message.internal.InternalCompareResponse;
import org.apache.directory.shared.ldap.message.internal.InternalResultResponse;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareRequestImpl
extends AbstractAbandonableRequest
implements InternalCompareRequest {
    static final long serialVersionUID = 1699731530016468977L;
    private DN name;
    private String attrId;
    private Value<?> attrVal;
    private InternalCompareResponse response;

    public CompareRequestImpl(int id) {
        super(id, TYPE);
    }

    @Override
    public DN getName() {
        return this.name;
    }

    @Override
    public void setName(DN name) {
        this.name = name;
    }

    @Override
    public Value<?> getAssertionValue() {
        return this.attrVal;
    }

    @Override
    public void setAssertionValue(String attrVal) {
        this.attrVal = new StringValue(attrVal);
    }

    @Override
    public void setAssertionValue(byte[] attrVal) {
        this.attrVal = attrVal != null ? new BinaryValue(attrVal) : null;
    }

    @Override
    public String getAttributeId() {
        return this.attrId;
    }

    @Override
    public void setAttributeId(String attrId) {
        this.attrId = attrId;
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    @Override
    public InternalResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new CompareResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalCompareRequest req = (InternalCompareRequest)obj;
        DN reqName = req.getName();
        if (this.name != null && reqName == null) {
            return false;
        }
        if (this.name == null && reqName != null) {
            return false;
        }
        if (this.name != null && reqName != null && !this.name.equals(req.getName())) {
            return false;
        }
        String reqId = req.getAttributeId();
        if (this.attrId != null && reqId == null) {
            return false;
        }
        if (this.attrId == null && reqId != null) {
            return false;
        }
        if (this.attrId != null && reqId != null && !this.attrId.equals(reqId)) {
            return false;
        }
        Value<?> reqVal = req.getAssertionValue();
        if (this.attrVal != null) {
            if (reqVal != null) {
                return this.attrVal.equals(reqVal);
            }
            return false;
        }
        return reqVal == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Compare request\n");
        sb.append("        Entry : '").append(this.name.toString()).append("'\n");
        sb.append("        Attribute description : '").append(this.attrId).append("'\n");
        sb.append("        Attribute value : '");
        if (!this.attrVal.isBinary()) {
            sb.append(this.attrVal.get());
        } else {
            byte[] binVal = this.attrVal.getBytes();
            sb.append(StringTools.utf8ToString(binVal)).append('/').append(StringTools.dumpBytes(binVal)).append("'\n");
        }
        return sb.toString();
    }
}

