/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ldap.server.tenant;

import org.apache.log4j.Logger;
import org.wso2.carbon.apacheds.AdminInfo;
import org.wso2.carbon.apacheds.PartitionInfo;
import org.wso2.carbon.apacheds.PartitionManager;
import org.wso2.carbon.ldap.server.configuration.LDAPConfigurationBuilder;
import org.wso2.carbon.ldap.server.exception.DirectoryServerException;
import org.wso2.carbon.ldap.server.util.EmbeddingLDAPException;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.tenant.LDAPTenantManager;
import org.wso2.carbon.user.core.tenant.Tenant;

public class LDAPTenantManagerService
implements LDAPTenantManager {
    private final Logger logger = Logger.getLogger(LDAPTenantManagerService.class);
    private PartitionManager ldapPartitionManager = null;
    private LDAPConfigurationBuilder ldapConfigurationBuilder = null;

    public LDAPTenantManagerService(PartitionManager partitionManager) {
        this.ldapPartitionManager = partitionManager;
    }

    public LDAPTenantManagerService(PartitionManager partitionManager, LDAPConfigurationBuilder ldapConfiguration) {
        this.ldapPartitionManager = partitionManager;
        this.ldapConfigurationBuilder = ldapConfiguration;
    }

    public int addTenant(Tenant tenant) throws UserStoreException {
        try {
            this.ldapPartitionManager.addPartition(this.getPartitionInfo(tenant));
        }
        catch (DirectoryServerException e) {
            String errorMessage = "Could not create a new partition for tenant id - " + tenant.getId() + "and for tenant domain - " + tenant.getDomain();
            this.logger.error(errorMessage, e);
            throw new UserStoreException(errorMessage, (Throwable)e);
        }
        catch (EmbeddingLDAPException e) {
            String errorMessage = "Could not create a new partition for tenant id - " + tenant.getId() + "and for tenant domain - " + tenant.getDomain();
            this.logger.error(errorMessage, e);
            throw new UserStoreException(errorMessage, (Throwable)e);
        }
        return tenant.getId();
    }

    public void updateTenant(Tenant tenant) throws UserStoreException {
    }

    public void deleteTenant(int i) throws UserStoreException {
        try {
            this.ldapPartitionManager.removePartition(String.valueOf(i));
        }
        catch (Exception e) {
            throw new UserStoreException("Could not remove partition for tenant id " + i, (Throwable)e);
        }
    }

    public void addPartitionToTenant(Tenant tenant) throws UserStoreException {
        try {
            this.ldapPartitionManager.initializeExistingPartition(this.getPartitionInfo(tenant));
        }
        catch (Exception e) {
            throw new UserStoreException("Can not add the new partition ", (Throwable)e);
        }
    }

    private String getTenantSuffix(String domain) {
        String[] domainParts = domain.split("\\.");
        StringBuilder suffixName = new StringBuilder();
        for (String domainPart : domainParts) {
            suffixName.append(",dc=").append(domainPart);
        }
        return suffixName.toString().replaceFirst(",", "");
    }

    private AdminInfo getAdminInfo(Tenant tenant) throws EmbeddingLDAPException {
        AdminInfo tenantAdminInfo = new AdminInfo();
        try {
            tenantAdminInfo.addObjectClass(this.ldapConfigurationBuilder.getLdapConfiguration().getAdminEntryObjectClass());
        }
        catch (EmbeddingLDAPException e) {
            String errorMessage = "Error in obtaining LDAP Configuration.";
            this.logger.error(errorMessage, e);
            throw new EmbeddingLDAPException(errorMessage, e);
        }
        if (tenant.getAdminName() != null) {
            tenantAdminInfo.setAdminUserName(tenant.getAdminName());
        }
        if (tenant.getAdminFirstName() != null) {
            tenantAdminInfo.setAdminCommonName(tenant.getAdminFirstName());
        }
        if (tenant.getAdminLastName() != null) {
            tenantAdminInfo.setAdminLastName(tenant.getAdminLastName());
        }
        if (tenant.getEmail() != null) {
            tenantAdminInfo.setAdminEmail(tenant.getEmail());
        }
        if (tenant.getAdminPassword() != null) {
            tenantAdminInfo.setAdminPassword(tenant.getAdminPassword());
        }
        return tenantAdminInfo;
    }

    private PartitionInfo getPartitionInfo(Tenant tenant) throws EmbeddingLDAPException {
        String partitionID = String.valueOf(tenant.getId());
        String realm = tenant.getDomain();
        String rootDN = this.getTenantSuffix(tenant.getDomain());
        AdminInfo tenantAdminInfo = this.getAdminInfo(tenant);
        return new PartitionInfo(partitionID, realm, rootDN, tenantAdminInfo);
    }
}

