/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.ResponseCallback;
import org.wso2.carbon.transport.http.netty.listener.WebSocketSourceHandler;
import org.wso2.carbon.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.PoolConfiguration;

public class SourceHandler
extends ChannelInboundHandlerAdapter {
    private static Logger log = LoggerFactory.getLogger(SourceHandler.class);
    protected ChannelHandlerContext ctx;
    protected HTTPCarbonMessage cMsg;
    protected ConnectionManager connectionManager;
    private Map<String, TargetChannel> channelFutureMap = new HashMap<String, TargetChannel>();
    protected Map<String, GenericObjectPool> targetChannelPool;
    protected ListenerConfiguration listenerConfiguration;
    private WebSocketServerHandshaker handshaker;

    public ListenerConfiguration getListenerConfiguration() {
        return this.listenerConfiguration;
    }

    public SourceHandler(ConnectionManager connectionManager, ListenerConfiguration listenerConfiguration) throws Exception {
        this.listenerConfiguration = listenerConfiguration;
        this.connectionManager = connectionManager;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        this.targetChannelPool = this.connectionManager.getTargetChannelPool();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        this.ctx = ctx;
        if (this.targetChannelPool == null) {
            this.targetChannelPool = this.connectionManager.getTargetChannelPool();
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage fullHttpMessage = (FullHttpMessage)msg;
            this.cMsg = (HTTPCarbonMessage)this.setupCarbonMessage(fullHttpMessage);
            this.publishToMessageProcessor(this.cMsg);
            ByteBuf content = ((FullHttpMessage)msg).content();
            this.cMsg.addHttpContent(new DefaultLastHttpContent(content));
            this.cMsg.setEndOfMsgAdded(true);
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(this.cMsg);
            }
        } else if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            HttpHeaders headers = httpRequest.headers();
            if ("Upgrade".equalsIgnoreCase(headers.get("Connection")) && "websocket".equalsIgnoreCase(headers.get("Upgrade"))) {
                log.info("Upgrading the connection from Http to WebSocket for channel : " + ctx.channel());
                this.handleWebSocketHandshake(httpRequest);
            } else {
                this.cMsg = (HTTPCarbonMessage)this.setupCarbonMessage(httpRequest);
                this.publishToMessageProcessor(this.cMsg);
            }
        } else if (this.cMsg != null && msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            this.cMsg.addHttpContent(httpContent);
            if (msg instanceof LastHttpContent) {
                this.cMsg.setEndOfMsgAdded(true);
                if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(this.cMsg);
                }
            }
        }
    }

    private void handleWebSocketHandshake(HttpRequest httpRequest) throws ProtocolException {
        try {
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(httpRequest), null, true);
            this.handshaker = wsFactory.newHandshaker(httpRequest);
            this.handshaker.handshake(this.ctx.channel(), httpRequest);
            boolean isSecuredConnection = false;
            if (this.listenerConfiguration.getSslConfig() != null) {
                isSecuredConnection = true;
            }
            ChannelPipeline pipeline = this.ctx.pipeline();
            int maxThreads = PoolConfiguration.getInstance().getEventGroupExecutorThreads();
            DefaultEventExecutorGroup executorGroup = new DefaultEventExecutorGroup(maxThreads);
            pipeline.addLast((EventExecutorGroup)executorGroup, "ws_handler", (ChannelHandler)new WebSocketSourceHandler(this.generateWebSocketChannelID(), this.connectionManager, this.listenerConfiguration, httpRequest, isSecuredConnection, this.ctx));
            pipeline.remove(this);
        }
        catch (Exception e) {
            this.ctx.channel().writeAndFlush(new CloseWebSocketFrame(1002, ""));
            this.ctx.close();
            throw new ProtocolException("Error occurred in HTTP to WebSocket Upgrade : " + e.getMessage());
        }
    }

    private String getWebSocketURL(HttpRequest req) {
        String protocol = "ws";
        if (this.listenerConfiguration.getSslConfig() != null) {
            protocol = "wss";
        }
        String url = protocol + "://" + req.headers().get("Host") + req.getUri();
        return url;
    }

    protected void publishToMessageProcessor(CarbonMessage cMsg) throws URISyntaxException {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(cMsg);
        }
        boolean continueRequest = true;
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            continueRequest = HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeRequestContinuationValidator(cMsg, carbonMessage2 -> {
                CarbonCallback responseCallback = (CarbonCallback)cMsg.getProperty("CALL_BACK");
                responseCallback.done(carbonMessage2);
            });
        }
        if (continueRequest) {
            CarbonMessageProcessor carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor();
            if (carbonMessageProcessor != null) {
                try {
                    carbonMessageProcessor.receive(cMsg, new ResponseCallback(this.ctx, cMsg));
                }
                catch (Exception e) {
                    log.error("Error while submitting CarbonMessage to CarbonMessageProcessor", e);
                }
            } else {
                log.error("Cannot find registered MessageProcessor for forward the message");
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
        }
        this.connectionManager.notifyChannelInactive();
    }

    public void addTargetChannel(HttpRoute route, TargetChannel targetChannel) {
        this.channelFutureMap.put(route.toString(), targetChannel);
    }

    public TargetChannel getChannelFuture(HttpRoute route) {
        return this.channelFutureMap.remove(route.toString());
    }

    public boolean isChannelFutureExists(HttpRoute route) {
        return this.channelFutureMap.get(route.toString()) != null;
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.targetChannelPool;
    }

    public ChannelHandlerContext getInboundChannelContext() {
        return this.ctx;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    protected CarbonMessage setupCarbonMessage(HttpMessage httpMessage) throws URISyntaxException {
        this.cMsg = new HTTPCarbonMessage();
        boolean isSecuredConnection = false;
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(this.cMsg);
        }
        this.cMsg.setProperty("PORT", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getPort());
        this.cMsg.setProperty("HOST", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getHostName());
        HttpRequest httpRequest = (HttpRequest)httpMessage;
        this.cMsg.setProperty("CHNL_HNDLR_CTX", this.ctx);
        this.cMsg.setProperty("SRC_HANDLER", this);
        this.cMsg.setProperty("HTTP_VERSION", httpRequest.getProtocolVersion().text());
        this.cMsg.setProperty("HTTP_METHOD", httpRequest.getMethod().name());
        this.cMsg.setProperty("LISTENER_PORT", ((InetSocketAddress)this.ctx.channel().localAddress()).getPort());
        this.cMsg.setProperty("LISTENER_INTERFACE_ID", this.listenerConfiguration.getId());
        this.cMsg.setProperty("PROTOCOL", "http");
        if (this.listenerConfiguration.getSslConfig() != null) {
            isSecuredConnection = true;
        }
        this.cMsg.setProperty("IS_SECURED_CONNECTION", isSecuredConnection);
        this.cMsg.setProperty("LOCAL_ADDRESS", this.ctx.channel().localAddress());
        this.cMsg.setProperty("LOCAL_NAME", ((InetSocketAddress)this.ctx.channel().localAddress()).getHostName());
        this.cMsg.setProperty("REMOTE_ADDRESS", this.ctx.channel().remoteAddress());
        this.cMsg.setProperty("REMOTE_HOST", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getHostName());
        this.cMsg.setProperty("REMOTE_PORT", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getPort());
        this.cMsg.setProperty("REQUEST_URL", httpRequest.getUri());
        ChannelHandler handler = this.ctx.handler();
        this.cMsg.setProperty("CHANNEL_ID", ((SourceHandler)handler).getListenerConfiguration().getId());
        this.cMsg.setProperty("TO", httpRequest.getUri());
        this.cMsg.setHeaders(Util.getHeaders(httpRequest).getAll());
        return this.cMsg;
    }

    protected String generateWebSocketChannelID() {
        return this.ctx.channel().id().asLongText();
    }
}

