/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.security.ldap.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apacheds.DirectoryServiceFactory;
import org.wso2.carbon.apacheds.KDCServer;
import org.wso2.carbon.apacheds.KdcConfiguration;
import org.wso2.carbon.apacheds.LDAPConfiguration;
import org.wso2.carbon.apacheds.LDAPServer;
import org.wso2.carbon.apacheds.PartitionInfo;
import org.wso2.carbon.apacheds.PartitionManager;
import org.wso2.carbon.ldap.server.exception.DirectoryServerException;
import org.wso2.carbon.ldap.server.util.EmbeddingLDAPException;
import org.wso2.msf4j.examples.petstore.security.ldap.server.LDAPServerConfigurationBuilder;
import org.wso2.msf4j.util.SystemVariableUtil;

public class ApacheDirectoryServerActivator {
    private static final Logger log = LoggerFactory.getLogger(ApacheDirectoryServerActivator.class);
    private String msf4jHome = SystemVariableUtil.getValue("MSF4J_HOME", System.getProperty("user.dir"));
    private LDAPServer ldapServer;
    private KDCServer kdcServer;

    public void start() {
        try {
            this.copyResources();
            LDAPServerConfigurationBuilder configurationBuilder = new LDAPServerConfigurationBuilder(this.getLdapConfigurationFile());
            configurationBuilder.buildConfigurations();
            boolean embeddedLDAPEnabled = configurationBuilder.isEmbeddedLDAPEnabled();
            if (embeddedLDAPEnabled) {
                LDAPConfiguration ldapConfiguration = configurationBuilder.getLdapConfiguration();
                this.setSchemaLocation();
                this.setWorkingDirectory(ldapConfiguration);
                this.startLdapServer(ldapConfiguration);
                this.ldapServer.changeConnectionUserPassword(configurationBuilder.getConnectionPassword());
                PartitionManager partitionManager = this.ldapServer.getPartitionManager();
                PartitionInfo defaultPartitionInfo = configurationBuilder.getPartitionConfigurations();
                boolean defaultPartitionAlreadyExisted = partitionManager.partitionDirectoryExists(defaultPartitionInfo.getPartitionId());
                if (!defaultPartitionAlreadyExisted) {
                    partitionManager.addPartition(defaultPartitionInfo);
                    if (this.kdcServer == null) {
                        this.kdcServer = DirectoryServiceFactory.createKDCServer(DirectoryServiceFactory.LDAPServerType.APACHE_DIRECTORY_SERVICE);
                    }
                    this.kdcServer.kerberizePartition(configurationBuilder.getPartitionConfigurations(), this.ldapServer);
                } else {
                    partitionManager.initializeExistingPartition(defaultPartitionInfo);
                }
                if (configurationBuilder.isKdcEnabled()) {
                    this.startKDC(configurationBuilder.getKdcConfigurations());
                }
                if (log.isDebugEnabled()) {
                    log.debug("apacheds-server started.");
                }
            } else {
                log.info("Embedded LDAP is disabled.");
            }
        }
        catch (FileNotFoundException e) {
            String errorMessage = "Could not start the embedded-ldap. ";
            log.error(errorMessage, e);
        }
        catch (DirectoryServerException e) {
            String errorMessage = "Could not start the embedded-ldap. ";
            log.error(errorMessage, e);
        }
        catch (EmbeddingLDAPException e) {
            String errorMessage = "Could not start the embedded-ldap. ";
            log.error(errorMessage, e);
        }
        catch (Exception e) {
            String errorMessage = "An unknown exception occurred while starting LDAP server. ";
            log.error(errorMessage, e);
        }
        catch (Throwable e) {
            String errorMessage = "An unknown error occurred while starting LDAP server. ";
            log.error(errorMessage, e);
        }
    }

    private void setSchemaLocation() throws EmbeddingLDAPException {
        String schemaLocation = "repository" + File.separator + "data" + File.separator + "is-default-schema.zip";
        File dataDir = new File(this.getCarbonHome(), schemaLocation);
        System.setProperty("schema.zip.store.location", dataDir.getAbsolutePath());
    }

    private String getCarbonHome() throws EmbeddingLDAPException {
        return this.msf4jHome;
    }

    private File getLdapConfigurationFile() throws EmbeddingLDAPException {
        String configurationFilePath = "repository" + File.separator + "conf" + File.separator + "embedded-ldap.xml";
        return new File(this.getCarbonHome(), configurationFilePath);
    }

    private void setWorkingDirectory(LDAPConfiguration ldapConfiguration) throws EmbeddingLDAPException {
        if (ldapConfiguration.getWorkingDirectory().equals(".")) {
            File dataDir = new File(this.getCarbonHome(), "repository" + File.separator + "data");
            if (!dataDir.exists() && !dataDir.mkdir()) {
                String msg = "Unable to create data directory at " + dataDir.getAbsolutePath();
                log.error(msg);
                throw new EmbeddingLDAPException(msg);
            }
            File bundleDataDir = new File(dataDir, "org.wso2.carbon.directory");
            if (!bundleDataDir.exists() && !bundleDataDir.mkdirs()) {
                String msg = "Unable to create schema data directory at " + bundleDataDir.getAbsolutePath();
                log.error(msg);
                throw new EmbeddingLDAPException(msg);
            }
            ldapConfiguration.setWorkingDirectory(bundleDataDir.getAbsolutePath());
        }
    }

    private void startLdapServer(LDAPConfiguration ldapConfiguration) throws DirectoryServerException {
        this.ldapServer = DirectoryServiceFactory.createLDAPServer(DirectoryServiceFactory.LDAPServerType.APACHE_DIRECTORY_SERVICE);
        log.info("Initializing Directory Server with working directory " + ldapConfiguration.getWorkingDirectory() + " and port " + ldapConfiguration.getLdapPort());
        this.ldapServer.init(ldapConfiguration);
        this.ldapServer.start();
    }

    private void startKDC(KdcConfiguration kdcConfiguration) throws DirectoryServerException {
        if (this.kdcServer == null) {
            this.kdcServer = DirectoryServiceFactory.createKDCServer(DirectoryServiceFactory.LDAPServerType.APACHE_DIRECTORY_SERVICE);
        }
        this.kdcServer.init(kdcConfiguration, this.ldapServer);
        this.kdcServer.start();
    }

    public void stop() throws Exception {
        if (this.kdcServer != null) {
            this.kdcServer.stop();
        }
        if (this.ldapServer != null) {
            this.ldapServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResources() throws IOException, EmbeddingLDAPException {
        File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        String repositoryDirectory = "repository";
        File destinationRoot = new File(this.getCarbonHome());
        File repository = new File(this.getCarbonHome() + File.separator + "repository");
        if (!repository.exists()) {
            try (JarFile jar = null;){
                jar = new JarFile(jarFile);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith("repository")) continue;
                    File destination = new File(destinationRoot, entry.getName());
                    if (entry.isDirectory() && destination.mkdirs()) continue;
                    InputStream in = null;
                    OutputStream out = null;
                    try {
                        in = jar.getInputStream(entry);
                        out = new FileOutputStream(destination);
                        IOUtils.copy(in, out);
                        IOUtils.closeQuietly(in);
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
        }
    }
}

