/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axiom.om.impl.OptimizationPolicyImpl;
import org.apache.axiom.om.util.CommonUtils;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.om.util.XMLStreamWriterFilter;
import org.apache.axiom.util.stax.xop.ContentIDGenerator;
import org.apache.axiom.util.stax.xop.OptimizationPolicy;
import org.apache.axiom.util.stax.xop.XOPEncodingStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MTOMXMLStreamWriter
implements XMLStreamWriter {
    private static Log log = LogFactory.getLog(MTOMXMLStreamWriter.class);
    private static boolean isDebugEnabled = log.isDebugEnabled();
    private static boolean isTraceEnabled = log.isTraceEnabled();
    private XMLStreamWriter xmlWriter;
    private OutputStream outStream;
    private LinkedList binaryNodeList = new LinkedList();
    private OMMultipartWriter multipartWriter;
    private OutputStream rootPartOutputStream;
    private OMOutputFormat format = new OMOutputFormat();
    private final OptimizationPolicy optimizationPolicy;
    private boolean isEndDocument = false;
    private boolean isComplete = false;
    private int depth = 0;
    private XMLStreamWriterFilter xmlStreamWriterFilter = null;

    public MTOMXMLStreamWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        if (isTraceEnabled) {
            log.trace("Call Stack =" + CommonUtils.callStackToString());
        }
        this.optimizationPolicy = new OptimizationPolicyImpl(this.format);
    }

    public MTOMXMLStreamWriter(OutputStream outStream, OMOutputFormat format) throws XMLStreamException, FactoryConfigurationError {
        if (isDebugEnabled) {
            log.debug("Creating MTOMXMLStreamWriter");
            log.debug("OutputStream =" + outStream.getClass());
            log.debug("OMFormat = " + format.toString());
        }
        if (isTraceEnabled) {
            log.trace("Call Stack =" + CommonUtils.callStackToString());
        }
        this.format = format;
        this.outStream = outStream;
        String encoding = format.getCharSetEncoding();
        if (encoding == null) {
            encoding = "utf-8";
            format.setCharSetEncoding("utf-8");
        }
        this.optimizationPolicy = new OptimizationPolicyImpl(format);
        if (format.isOptimized()) {
            this.multipartWriter = new OMMultipartWriter(outStream, format);
            try {
                this.rootPartOutputStream = this.multipartWriter.writeRootPart();
            }
            catch (IOException ex) {
                throw new XMLStreamException(ex);
            }
            ContentIDGenerator contentIDGenerator = new ContentIDGenerator(){

                public String generateContentID(String existingContentID) {
                    return existingContentID != null ? existingContentID : MTOMXMLStreamWriter.this.getNextContentId();
                }
            };
            this.xmlWriter = new XOPEncodingStreamWriter(StAXUtils.createXMLStreamWriter(format.getStAXWriterConfiguration(), this.rootPartOutputStream, encoding), contentIDGenerator, this.optimizationPolicy);
        } else {
            this.xmlWriter = StAXUtils.createXMLStreamWriter(format.getStAXWriterConfiguration(), outStream, format.getCharSetEncoding());
        }
        this.xmlStreamWriterFilter = format.getXmlStreamWriterFilter();
        if (this.xmlStreamWriterFilter != null) {
            if (log.isDebugEnabled()) {
                log.debug("Installing XMLStreamWriterFilter " + this.xmlStreamWriterFilter);
            }
            this.xmlStreamWriterFilter.setDelegate(this.xmlWriter);
            this.xmlWriter = this.xmlStreamWriterFilter;
        }
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string);
        ++this.depth;
    }

    public void writeStartElement(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1);
        ++this.depth;
    }

    public void writeStartElement(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1, string2);
        ++this.depth;
    }

    public void writeEmptyElement(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeEmptyElement(string, string1);
    }

    public void writeEmptyElement(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeEmptyElement(string, string1, string2);
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.xmlWriter.writeEmptyElement(string);
    }

    public void writeEndElement() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
        --this.depth;
    }

    public void writeEndDocument() throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("writeEndDocument");
        }
        this.xmlWriter.writeEndDocument();
        this.isEndDocument = true;
    }

    public void close() throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("close");
        }
        this.xmlWriter.close();
    }

    public void flush() throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("Calling MTOMXMLStreamWriter.flush");
        }
        this.xmlWriter.flush();
        if (this.format.isOptimized() && !this.isComplete & (this.isEndDocument || this.depth == 0)) {
            if (isDebugEnabled) {
                log.debug("The XML writing is completed.  Now the attachments are written");
            }
            this.isComplete = true;
            try {
                this.rootPartOutputStream.close();
                XOPEncodingStreamWriter encoder = (XOPEncodingStreamWriter)this.xmlWriter;
                for (String contentID : encoder.getContentIDs()) {
                    this.multipartWriter.writePart(encoder.getDataHandler(contentID), contentID);
                }
                for (OMText text : this.binaryNodeList) {
                    this.multipartWriter.writePart((DataHandler)text.getDataHandler(), text.getContentID());
                }
                this.multipartWriter.complete();
            }
            catch (IOException e) {
                throw new OMException(e);
            }
        }
    }

    public void writeAttribute(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1);
    }

    public void writeAttribute(String string, String string1, String string2, String string3) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1, string2, string3);
    }

    public void writeAttribute(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1, string2);
    }

    public void writeNamespace(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeNamespace(string, string1);
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.xmlWriter.writeDefaultNamespace(string);
    }

    public void writeComment(String string) throws XMLStreamException {
        this.xmlWriter.writeComment(string);
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.xmlWriter.writeProcessingInstruction(string);
    }

    public void writeProcessingInstruction(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeProcessingInstruction(string, string1);
    }

    public void writeCData(String string) throws XMLStreamException {
        this.xmlWriter.writeCData(string);
    }

    public void writeDTD(String string) throws XMLStreamException {
        this.xmlWriter.writeDTD(string);
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        this.xmlWriter.writeEntityRef(string);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.xmlWriter.writeStartDocument();
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.xmlWriter.writeStartDocument(string);
    }

    public void writeStartDocument(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeStartDocument(string, string1);
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.xmlWriter.writeCharacters(string);
    }

    public void writeCharacters(char[] chars, int i, int i1) throws XMLStreamException {
        this.xmlWriter.writeCharacters(chars, i, i1);
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this.xmlWriter.getPrefix(string);
    }

    public void setPrefix(String string, String string1) throws XMLStreamException {
        this.xmlWriter.setPrefix(string, string1);
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.xmlWriter.setDefaultNamespace(string);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.xmlWriter.setNamespaceContext(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.xmlWriter.getNamespaceContext();
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.xmlWriter.getProperty(string);
    }

    public boolean isOptimized() {
        return this.format.isOptimized();
    }

    public String getContentType() {
        return this.format.getContentType();
    }

    public void writeOptimized(OMText node) {
        if (isDebugEnabled) {
            log.debug("Start MTOMXMLStreamWriter.writeOptimized()");
        }
        this.binaryNodeList.add(node);
        if (isDebugEnabled) {
            log.debug("Exit MTOMXMLStreamWriter.writeOptimized()");
        }
    }

    public boolean isOptimizedThreshold(OMText node) {
        try {
            return this.optimizationPolicy.isOptimized((DataHandler)node.getDataHandler(), true);
        }
        catch (IOException ex) {
            return true;
        }
    }

    public void setXmlStreamWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
    }

    public XMLStreamWriter getXmlStreamWriter() {
        return this.xmlWriter;
    }

    public String getMimeBoundary() {
        return this.format.getMimeBoundary();
    }

    public String getRootContentId() {
        return this.format.getRootContentId();
    }

    public String getNextContentId() {
        return this.format.getNextContentId();
    }

    public String getCharSetEncoding() {
        return this.format.getCharSetEncoding();
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.format.setCharSetEncoding(charSetEncoding);
    }

    public String getXmlVersion() {
        return this.format.getXmlVersion();
    }

    public void setXmlVersion(String xmlVersion) {
        this.format.setXmlVersion(xmlVersion);
    }

    public void setSoap11(boolean b) {
        this.format.setSOAP11(b);
    }

    public boolean isIgnoreXMLDeclaration() {
        return this.format.isIgnoreXMLDeclaration();
    }

    public void setIgnoreXMLDeclaration(boolean ignoreXMLDeclaration) {
        this.format.setIgnoreXMLDeclaration(ignoreXMLDeclaration);
    }

    public void setDoOptimize(boolean b) {
        this.format.setDoOptimize(b);
    }

    public OMOutputFormat getOutputFormat() {
        return this.format;
    }

    public void setOutputFormat(OMOutputFormat format) {
        this.format = format;
    }

    public OutputStream getOutputStream() throws XMLStreamException {
        if (this.xmlStreamWriterFilter != null) {
            if (log.isDebugEnabled()) {
                log.debug("getOutputStream returning null due to presence of XMLStreamWriterFilter " + this.xmlStreamWriterFilter);
            }
            return null;
        }
        OutputStream os = null;
        os = this.rootPartOutputStream != null ? this.rootPartOutputStream : this.outStream;
        if (isDebugEnabled) {
            if (os == null) {
                log.debug("Direct access to the output stream is not available.");
            } else if (this.rootPartOutputStream != null) {
                log.debug("Returning access to the buffered xml stream: " + this.rootPartOutputStream);
            } else {
                log.debug("Returning access to the original output stream: " + os);
            }
        }
        if (os != null) {
            this.writeCharacters("");
            this.flush();
        }
        return os;
    }

    private void writeOutput(OMText textNode) throws XMLStreamException {
        int type = textNode.getType();
        if (type == 4 || type == 6) {
            this.writeCharacters(textNode.getText());
        } else if (type == 12) {
            this.writeCData(textNode.getText());
        } else if (type == 9) {
            this.writeEntityRef(textNode.getText());
        }
    }

    public void setFilter(XMLStreamWriterFilter filter) {
        if (filter != null) {
            if (log.isDebugEnabled()) {
                log.debug("setting filter " + filter.getClass());
            }
            this.xmlStreamWriterFilter = filter;
            filter.setDelegate(this.xmlWriter);
            this.xmlWriter = filter;
        }
    }

    public XMLStreamWriterFilter removeFilter() {
        XMLStreamWriterFilter filter = null;
        if (this.xmlStreamWriterFilter != null) {
            filter = this.xmlStreamWriterFilter;
            if (log.isDebugEnabled()) {
                log.debug("removing filter " + filter.getClass());
            }
            this.xmlWriter = this.xmlStreamWriterFilter.getDelegate();
            filter.setDelegate(null);
            this.xmlStreamWriterFilter = this.xmlWriter instanceof XMLStreamWriterFilter ? (XMLStreamWriterFilter)this.xmlWriter : null;
        }
        return filter;
    }
}

