/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.util.Stack;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMXMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMXMLStreamReaderValidator
implements OMXMLStreamReader {
    private static Log log = LogFactory.getLog(OMXMLStreamReaderValidator.class);
    private static boolean IS_DEBUG_ENABLED = log.isDebugEnabled();
    private static boolean IS_ADV_DEBUG_ENABLED = false;
    private final OMXMLStreamReader delegate;
    private boolean throwExceptions = false;
    private Stack stack = new Stack();

    public OMXMLStreamReaderValidator(OMXMLStreamReader delegate, boolean throwExceptions) {
        this.delegate = delegate;
        this.throwExceptions = throwExceptions;
    }

    public int next() throws XMLStreamException {
        int event = this.delegate.next();
        this.logParserState();
        switch (event) {
            case 1: {
                this.stack.push(this.delegate.getName());
                break;
            }
            case 2: {
                QName delegateQName = this.delegate.getName();
                if (this.stack.isEmpty()) {
                    this.reportMismatchedEndElement(null, delegateQName);
                    break;
                }
                QName expectedQName = (QName)this.stack.pop();
                if (expectedQName.equals(delegateQName)) break;
                this.reportMismatchedEndElement(expectedQName, delegateQName);
                break;
            }
        }
        return event;
    }

    private void reportMismatchedEndElement(QName expectedQName, QName delegateQName) {
        String text = null;
        text = expectedQName == null ? "An END_ELEMENT event for " + delegateQName + " was encountered, but the START_ELEMENT stack is empty." : "An END_ELEMENT event for " + delegateQName + " was encountered, but this doesn't match the corresponding START_ELEMENT " + expectedQName + " event.";
        if (IS_DEBUG_ENABLED) {
            log.debug(text);
        }
        if (this.throwExceptions) {
            throw new OMException(text);
        }
    }

    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    public int getAttributeCount() {
        return this.delegate.getAttributeCount();
    }

    public String getAttributeLocalName(int arg0) {
        return this.delegate.getAttributeLocalName(arg0);
    }

    public QName getAttributeName(int arg0) {
        return this.delegate.getAttributeName(arg0);
    }

    public String getAttributeNamespace(int arg0) {
        return this.delegate.getAttributeNamespace(arg0);
    }

    public String getAttributePrefix(int arg0) {
        return this.delegate.getAttributePrefix(arg0);
    }

    public String getAttributeType(int arg0) {
        return this.delegate.getAttributeType(arg0);
    }

    public String getAttributeValue(int arg0) {
        return this.delegate.getAttributeValue(arg0);
    }

    public String getAttributeValue(String arg0, String arg1) {
        return this.delegate.getAttributeValue(arg0, arg1);
    }

    public String getCharacterEncodingScheme() {
        return this.delegate.getCharacterEncodingScheme();
    }

    public String getElementText() throws XMLStreamException {
        return this.delegate.getElementText();
    }

    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    public int getEventType() {
        return this.delegate.getEventType();
    }

    public String getLocalName() {
        return this.delegate.getLocalName();
    }

    public Location getLocation() {
        return this.delegate.getLocation();
    }

    public QName getName() {
        return this.delegate.getName();
    }

    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    public int getNamespaceCount() {
        return this.delegate.getNamespaceCount();
    }

    public String getNamespacePrefix(int arg0) {
        return this.delegate.getNamespacePrefix(arg0);
    }

    public String getNamespaceURI() {
        return this.delegate.getNamespaceURI();
    }

    public String getNamespaceURI(int arg0) {
        return this.delegate.getNamespaceURI(arg0);
    }

    public String getNamespaceURI(String arg0) {
        return this.delegate.getNamespaceURI(arg0);
    }

    public String getPIData() {
        return this.delegate.getPIData();
    }

    public String getPITarget() {
        return this.delegate.getPITarget();
    }

    public String getPrefix() {
        return this.delegate.getPrefix();
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        return this.delegate.getProperty(arg0);
    }

    public String getText() {
        return this.delegate.getText();
    }

    public char[] getTextCharacters() {
        return this.delegate.getTextCharacters();
    }

    public int getTextCharacters(int arg0, char[] arg1, int arg2, int arg3) throws XMLStreamException {
        return this.delegate.getTextCharacters(arg0, arg1, arg2, arg3);
    }

    public int getTextLength() {
        return this.delegate.getTextLength();
    }

    public int getTextStart() {
        return this.delegate.getTextStart();
    }

    public String getVersion() {
        return this.delegate.getVersion();
    }

    public boolean hasName() {
        return this.delegate.hasName();
    }

    public boolean hasNext() throws XMLStreamException {
        return this.delegate.hasNext();
    }

    public boolean hasText() {
        return this.delegate.hasText();
    }

    public boolean isAttributeSpecified(int arg0) {
        return this.delegate.isAttributeSpecified(arg0);
    }

    public boolean isCharacters() {
        return this.delegate.isCharacters();
    }

    public boolean isEndElement() {
        return this.delegate.isEndElement();
    }

    public boolean isStandalone() {
        return this.delegate.isStandalone();
    }

    public boolean isStartElement() {
        return this.delegate.isStartElement();
    }

    public boolean isWhiteSpace() {
        return this.delegate.isWhiteSpace();
    }

    public int nextTag() throws XMLStreamException {
        return this.delegate.nextTag();
    }

    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        this.delegate.require(arg0, arg1, arg2);
    }

    public boolean standaloneSet() {
        return this.delegate.standaloneSet();
    }

    protected void logParserState() {
        if (IS_ADV_DEBUG_ENABLED) {
            int currentEvent = this.delegate.getEventType();
            switch (currentEvent) {
                case 1: {
                    log.trace("START_ELEMENT: ");
                    log.trace("  QName: " + this.delegate.getName());
                    break;
                }
                case 7: {
                    log.trace("START_DOCUMENT: ");
                    break;
                }
                case 4: {
                    log.trace("CHARACTERS: ");
                    log.trace("[" + this.delegate.getText() + "]");
                    break;
                }
                case 12: {
                    log.trace("CDATA: ");
                    log.trace("[" + this.delegate.getText() + "]");
                    break;
                }
                case 2: {
                    log.trace("END_ELEMENT: ");
                    log.trace("  QName: " + this.delegate.getName());
                    break;
                }
                case 8: {
                    log.trace("END_DOCUMENT: ");
                    break;
                }
                case 6: {
                    log.trace("SPACE: ");
                    log.trace("[" + this.delegate.getText() + "]");
                    break;
                }
                case 5: {
                    log.trace("COMMENT: ");
                    log.trace("[" + this.delegate.getText() + "]");
                    break;
                }
                case 11: {
                    log.trace("DTD: ");
                    log.trace("[" + this.delegate.getText() + "]");
                    break;
                }
                case 3: {
                    log.trace("PROCESSING_INSTRUCTION: ");
                    log.trace("   [" + this.delegate.getPITarget() + "][" + this.delegate.getPIData() + "]");
                    break;
                }
                case 9: {
                    log.trace("ENTITY_REFERENCE: ");
                    log.trace("    " + this.delegate.getLocalName() + "[" + this.delegate.getText() + "]");
                    break;
                }
                default: {
                    log.trace("UNKNOWN_STATE: " + currentEvent);
                }
            }
        }
    }

    public DataHandler getDataHandler(String blobcid) {
        return this.delegate.getDataHandler(blobcid);
    }

    public boolean isInlineMTOM() {
        return this.delegate.isInlineMTOM();
    }

    public void setInlineMTOM(boolean value) {
        this.delegate.setInlineMTOM(value);
    }
}

