/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.authn.AbstractAuthenticator;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.collective.CollectiveAttributeInterceptor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.event.EventInterceptor;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.core.trigger.TriggerInterceptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.constants.LdapSecurityConstants;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.directory.shared.ldap.util.UnixCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthenticator
extends AbstractAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAuthenticator.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final int SHA1_LENGTH = 20;
    private static final int MD5_LENGTH = 16;
    private final LRUMap credentialCache;
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final Collection<String> USERLOOKUP_BYPASS;

    public SimpleAuthenticator() {
        super(AuthenticationLevel.SIMPLE.toString());
        this.credentialCache = new LRUMap(100);
    }

    public SimpleAuthenticator(int cacheSize) {
        super(AuthenticationLevel.SIMPLE.toString());
        this.credentialCache = new LRUMap(cacheSize > 0 ? cacheSize : 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapPrincipal getStoredPassword(BindOperationContext opContext) throws Exception {
        LdapPrincipal principal = null;
        LRUMap lRUMap = this.credentialCache;
        synchronized (lRUMap) {
            principal = (LdapPrincipal)this.credentialCache.get(opContext.getDn().getNormName());
        }
        if (principal == null) {
            byte[] storedPassword = this.lookupUserPassword(opContext);
            if (storedPassword == null) {
                storedPassword = ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            principal = new LdapPrincipal(opContext.getDn(), AuthenticationLevel.SIMPLE, storedPassword);
            LRUMap lRUMap2 = this.credentialCache;
            synchronized (lRUMap2) {
                this.credentialCache.put(opContext.getDn().getNormName(), principal);
            }
        }
        return principal;
    }

    public LdapPrincipal authenticate(BindOperationContext opContext) throws Exception {
        LdapPrincipal principal;
        byte[] storedPassword;
        byte[] credentials;
        if (IS_DEBUG) {
            LOG.debug("Authenticating {}", (Object)opContext.getDn());
        }
        if (Arrays.equals(credentials = opContext.getCredentials(), storedPassword = (principal = this.getStoredPassword(opContext)).getUserPassword())) {
            if (IS_DEBUG) {
                LOG.debug("{} Authenticated", (Object)opContext.getDn());
            }
            return principal;
        }
        LdapSecurityConstants algorithm = this.findAlgorithm(storedPassword);
        if (algorithm != null) {
            EncryptionMethod encryptionMethod = new EncryptionMethod(algorithm, null);
            byte[] encryptedStored = this.splitCredentials(storedPassword, encryptionMethod);
            byte[] userPassword = this.encryptPassword(credentials, encryptionMethod);
            if (Arrays.equals(userPassword, encryptedStored)) {
                if (IS_DEBUG) {
                    LOG.debug("{} Authenticated", (Object)opContext.getDn());
                }
                return principal;
            }
            String message = I18n.err(I18n.ERR_230, opContext.getDn().getName());
            LOG.info(message);
            throw new LdapAuthenticationException(message);
        }
        String message = I18n.err(I18n.ERR_230, opContext.getDn().getName());
        LOG.info(message);
        throw new LdapAuthenticationException(message);
    }

    private static void split(byte[] all, int offset, byte[] left, byte[] right) {
        System.arraycopy(all, offset, left, 0, left.length);
        System.arraycopy(all, offset + left.length, right, 0, right.length);
    }

    private byte[] splitCredentials(byte[] credentials, EncryptionMethod encryptionMethod) {
        int algoLength = encryptionMethod.algorithm.getName().length() + 2;
        switch (encryptionMethod.algorithm) {
            case HASH_METHOD_MD5: 
            case HASH_METHOD_SHA: 
            case HASH_METHOD_SHA256: {
                try {
                    return Base64.decode(new String(credentials, algoLength, credentials.length - algoLength, "UTF-8").toCharArray());
                }
                catch (UnsupportedEncodingException uee) {
                    return credentials;
                }
            }
            case HASH_METHOD_SMD5: {
                try {
                    byte[] passwordAndSalt = Base64.decode(new String(credentials, algoLength, credentials.length - algoLength, "UTF-8").toCharArray());
                    int saltLength = passwordAndSalt.length - 16;
                    EncryptionMethod.access$202(encryptionMethod, new byte[saltLength]);
                    byte[] password = new byte[16];
                    SimpleAuthenticator.split(passwordAndSalt, 0, password, encryptionMethod.salt);
                    return password;
                }
                catch (UnsupportedEncodingException uee) {
                    return credentials;
                }
            }
            case HASH_METHOD_SSHA: {
                try {
                    byte[] passwordAndSalt = Base64.decode(new String(credentials, algoLength, credentials.length - algoLength, "UTF-8").toCharArray());
                    int saltLength = passwordAndSalt.length - 20;
                    EncryptionMethod.access$202(encryptionMethod, new byte[saltLength]);
                    byte[] password = new byte[20];
                    SimpleAuthenticator.split(passwordAndSalt, 0, password, encryptionMethod.salt);
                    return password;
                }
                catch (UnsupportedEncodingException uee) {
                    return credentials;
                }
            }
            case HASH_METHOD_CRYPT: {
                EncryptionMethod.access$202(encryptionMethod, new byte[2]);
                byte[] password = new byte[credentials.length - encryptionMethod.salt.length - algoLength];
                SimpleAuthenticator.split(credentials, algoLength, encryptionMethod.salt, password);
                return password;
            }
        }
        return credentials;
    }

    private LdapSecurityConstants findAlgorithm(byte[] credentials) {
        if (credentials == null || credentials.length == 0) {
            return null;
        }
        if (credentials[0] == 123) {
            int pos;
            for (pos = 1; pos < credentials.length && credentials[pos] != 125; ++pos) {
            }
            if (pos < credentials.length) {
                if (pos == 1) {
                    return null;
                }
                String algorithm = new String(credentials, 1, pos - 1).toLowerCase();
                return LdapSecurityConstants.getAlgorithm(algorithm);
            }
            return null;
        }
        return null;
    }

    private static byte[] digest(LdapSecurityConstants algorithm, byte[] password, byte[] salt) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm.getName());
        }
        catch (NoSuchAlgorithmException e1) {
            return null;
        }
        if (salt != null) {
            digest.update(password);
            digest.update(salt);
            return digest.digest();
        }
        return digest.digest(password);
    }

    private byte[] encryptPassword(byte[] credentials, EncryptionMethod encryptionMethod) {
        byte[] salt = encryptionMethod.salt;
        switch (encryptionMethod.algorithm) {
            case HASH_METHOD_SHA: 
            case HASH_METHOD_SSHA: {
                return SimpleAuthenticator.digest(LdapSecurityConstants.HASH_METHOD_SHA, credentials, salt);
            }
            case HASH_METHOD_SHA256: {
                return SimpleAuthenticator.digest(LdapSecurityConstants.HASH_METHOD_SHA256, credentials, salt);
            }
            case HASH_METHOD_MD5: 
            case HASH_METHOD_SMD5: {
                return SimpleAuthenticator.digest(LdapSecurityConstants.HASH_METHOD_MD5, credentials, salt);
            }
            case HASH_METHOD_CRYPT: {
                if (salt == null) {
                    salt = new byte[2];
                    SecureRandom sr = new SecureRandom();
                    int i1 = sr.nextInt(64);
                    int i2 = sr.nextInt(64);
                    salt[0] = (byte)(i1 < 12 ? i1 + 46 : (i1 < 38 ? i1 + 65 - 12 : i1 + 97 - 38));
                    salt[1] = (byte)(i2 < 12 ? i2 + 46 : (i2 < 38 ? i2 + 65 - 12 : i2 + 97 - 38));
                }
                String saltWithCrypted = UnixCrypt.crypt(StringTools.utf8ToString(credentials), StringTools.utf8ToString(salt));
                String crypted = saltWithCrypted.substring(2);
                return StringTools.getBytesUtf8(crypted);
            }
        }
        return credentials;
    }

    private byte[] lookupUserPassword(BindOperationContext opContext) throws Exception {
        ClonedServerEntry userEntry;
        try {
            LookupOperationContext lookupContext = new LookupOperationContext(this.getDirectoryService().getAdminSession(), opContext.getDn());
            lookupContext.setByPassed(USERLOOKUP_BYPASS);
            userEntry = this.getDirectoryService().getOperationManager().lookup(lookupContext);
            if (userEntry == null) {
                DN dn = opContext.getDn();
                String upDn = dn == null ? "" : dn.getName();
                throw new LdapAuthenticationException(I18n.err(I18n.ERR_231, upDn));
            }
        }
        catch (Exception cause) {
            LOG.error(I18n.err(I18n.ERR_6, cause.getLocalizedMessage()));
            LdapAuthenticationException e = new LdapAuthenticationException(cause.getLocalizedMessage());
            e.initCause(e);
            throw e;
        }
        EntryAttribute userPasswordAttr = userEntry.get("userPassword");
        if (userPasswordAttr == null) {
            return StringTools.EMPTY_BYTES;
        }
        Value<?> userPassword = userPasswordAttr.get();
        return userPassword.getBytes();
    }

    protected String getAlgorithmForHashedPassword(byte[] password) throws IllegalArgumentException {
        String result = null;
        String sPassword = StringTools.utf8ToString(password);
        int rightParen = sPassword.indexOf(125);
        if (sPassword.length() > 2 && sPassword.charAt(0) == '{' && rightParen > -1) {
            String algorithm = sPassword.substring(1, rightParen);
            if (LdapSecurityConstants.HASH_METHOD_CRYPT.getName().equalsIgnoreCase(algorithm)) {
                return algorithm;
            }
            try {
                MessageDigest.getInstance(algorithm);
                result = algorithm;
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn("Unknown message digest algorithm in password: " + algorithm, e);
            }
        }
        return result;
    }

    protected String createDigestedPassword(String algorithm, byte[] password) throws IllegalArgumentException {
        try {
            if (LdapSecurityConstants.HASH_METHOD_CRYPT.getName().equalsIgnoreCase(algorithm)) {
                String saltWithCrypted = UnixCrypt.crypt(StringTools.utf8ToString(password), "");
                String crypted = saltWithCrypted.substring(2);
                return '{' + algorithm + '}' + Arrays.toString(StringTools.getBytesUtf8(crypted));
            }
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] fingerPrint = digest.digest(password);
            char[] encoded = Base64.encode(fingerPrint);
            return '{' + algorithm + '}' + new String(encoded);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error(I18n.err(I18n.ERR_7, algorithm));
            throw new IllegalArgumentException(nsae.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(DN bindDn) {
        LRUMap lRUMap = this.credentialCache;
        synchronized (lRUMap) {
            this.credentialCache.remove(bindDn.getNormName());
        }
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add(NormalizationInterceptor.class.getName());
        c.add(AuthenticationInterceptor.class.getName());
        c.add(AciAuthorizationInterceptor.class.getName());
        c.add(DefaultAuthorizationInterceptor.class.getName());
        c.add(ExceptionInterceptor.class.getName());
        c.add(OperationalAttributeInterceptor.class.getName());
        c.add(SchemaInterceptor.class.getName());
        c.add(SubentryInterceptor.class.getName());
        c.add(CollectiveAttributeInterceptor.class.getName());
        c.add(EventInterceptor.class.getName());
        c.add(TriggerInterceptor.class.getName());
        USERLOOKUP_BYPASS = Collections.unmodifiableCollection(c);
    }

    private class EncryptionMethod {
        private byte[] salt;
        private LdapSecurityConstants algorithm;

        private EncryptionMethod(LdapSecurityConstants algorithm, byte[] salt) {
            this.algorithm = algorithm;
            this.salt = salt;
        }

        static /* synthetic */ byte[] access$202(EncryptionMethod x0, byte[] x1) {
            x0.salt = x1;
            return x1;
        }
    }
}

