/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.TicketEncoder;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class ApplicationRequestEncoder {
    public static final int APPLICATION_CODE = 14;

    public byte[] encode(ApplicationRequest request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        DERSequence requestSequence = this.encodeReplySequence(request);
        aos.writeObject(DERApplicationSpecific.valueOf(14, requestSequence));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeReplySequence(ApplicationRequest message) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, DERInteger.valueOf(message.getProtocolVersionNumber())));
        sequence.add(new DERTaggedObject(1, DERInteger.valueOf(message.getMessageType().getOrdinal())));
        sequence.add(new DERTaggedObject(2, new DERBitString(message.getApOptions().getBytes())));
        sequence.add(new DERTaggedObject(3, TicketEncoder.encode(message.getTicket())));
        sequence.add(new DERTaggedObject(4, EncryptedDataEncoder.encodeSequence(message.getEncPart())));
        return sequence;
    }
}

